/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.slice.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.filter.FtSqlSource;
import com.efuture.ocp.common.slice.filter.CollectionSelectWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class CollectionDeleteWrapper
extends CollectionSelectWrapper {
    protected void onDeleteStatement(Logger logger, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt, String partionKey, String sliceKey) throws Throwable {
        SQLDeleteStatement deleteStmt = (SQLDeleteStatement)stmt;
        String collectionName = deleteStmt.getTableName().getSimpleName();
        SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
        String authWhereSql = this.getPartionWhere(collectionName, null, partionKey, sliceKey);
        if (!StringUtils.isEmpty((Object)authWhereSql)) {
            SQLBinaryOpExpr whereExpr;
            SQLExpr authWhereExpr = this.getWhereInfo(authWhereSql);
            if (deleteStmt.getWhere() != null && deleteStmt.getWhere() instanceof SQLBinaryOpExpr) {
                whereExpr = (SQLBinaryOpExpr)deleteStmt.getWhere();
                if (whereExpr != null) {
                    newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                    newWhereExpr.setLeft((SQLExpr)whereExpr);
                    newWhereExpr.setRight(authWhereExpr);
                }
            } else if (deleteStmt.getWhere() != null && deleteStmt.getWhere() instanceof SQLInListExpr) {
                whereExpr = (SQLInListExpr)deleteStmt.getWhere();
                if (whereExpr != null) {
                    newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                    newWhereExpr.setLeft((SQLExpr)whereExpr);
                    newWhereExpr.setRight(authWhereExpr);
                }
            } else {
                newWhereExpr = authWhereExpr;
            }
            deleteStmt.setWhere((SQLExpr)newWhereExpr);
        }
        StringBuffer newSql = new StringBuffer();
        MySqlOutputVisitor visitor = null;
        if (this.getDbType().equals("mysql")) {
            visitor = new MySqlOutputVisitor((Appendable)newSql);
        } else if (this.getDbType().equals("oracle")) {
            visitor = new OracleOutputVisitor((Appendable)newSql);
        } else {
            throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
        }
        visitor.visit(deleteStmt);
        visitor.println();
        visitor.endVisit(deleteStmt);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        logJson.put("newSql", (Object)newSql.toString());
        CollectionDeleteWrapper.sliceFilterLog(String.format("newSQL --->%1$s", newSql.toString()), new Object[0]);
    }
}

