/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.slice.filter;

import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.slice.entity.SplitConfigBean;
import com.efuture.ocp.common.slice.entity.SplitTableConfigBean;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class SliceBase {
    public static int MAPPED_STATEMENT_INDEX = 0;
    public static int PARAMETER_INDEX = 1;
    public static int ROWBOUNDS_INDEX = 2;
    public static int RESULT_HANDLER_INDEX = 3;
    public static int CACHEKEY_INDEX = 4;
    public static int BOUNDSQL_INDEX = 5;
    protected static Logger logger = LoggerFactory.getLogger(SliceBase.class);
    private static ScheduledExecutorService service = null;
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<String, String> organizationMap;
    private static Map<String, String> collectionMap;
    private static Boolean isDebugLog;
    private static Boolean isEnableSlice;
    private static String noFindError;
    private static int reloadTime;
    private List<String> LIST_ParaTable = Arrays.asList("splitconfig", "splittableconfig");

    public static FStorageOperations getStorageOperations() {
        return SpringBeanFactory.getBean("GlobalStorageOperation", FStorageOperations.class);
    }

    private static void initOrganizationMap(FStorageOperations conn) {
        Query qur = new Query();
        List list = conn.select(qur, SplitConfigBean.class);
        if (list != null && list.size() > 0) {
            organizationMap.clear();
            for (SplitConfigBean scb : list) {
                String key = String.valueOf(scb.getEnt_id()).concat("-").concat(scb.getShopCode());
                organizationMap.put(key, scb.getSplitCode());
            }
        }
    }

    private static void initCollectionMap(FStorageOperations conn) {
        Query qur = new Query();
        List list = conn.select(qur, SplitTableConfigBean.class);
        if (list != null && list.size() > 0) {
            collectionMap.clear();
            for (SplitTableConfigBean scb : list) {
                String key = scb.getSplitTableName();
                collectionMap.put(key, scb.getFieldName());
            }
        }
    }

    public static void init() {
        if (service == null) {
            SliceBase.doInit();
            service = Executors.newSingleThreadScheduledExecutor();
            service.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    SliceBase.doInit();
                }
            }, SliceBase.reloadTime(), SliceBase.reloadTime(), TimeUnit.SECONDS);
        }
    }

    public static synchronized void doInit() {
        if (organizationMap == null) {
            organizationMap = new HashMap<String, String>();
        }
        if (collectionMap == null) {
            collectionMap = new HashMap<String, String>();
        }
        FStorageOperations conn = null;
        try {
            conn = SliceBase.getStorageOperations();
            SliceBase.initOrganizationMap(conn);
            SliceBase.initCollectionMap(conn);
        }
        finally {
            if (conn != null) {
                conn.destroy();
            }
        }
    }

    public static Map<String, String> getCollectionMap() {
        if (collectionMap == null || organizationMap == null) {
            SliceBase.init();
        }
        if (collectionMap.isEmpty() || organizationMap.isEmpty()) {
            SliceBase.init();
        }
        return collectionMap;
    }

    public static Map<String, String> getOrganizationMap() {
        if (collectionMap == null || organizationMap == null) {
            SliceBase.init();
        }
        if (collectionMap.isEmpty() || organizationMap.isEmpty()) {
            SliceBase.init();
        }
        return organizationMap;
    }

    public static Set<String> getAllSlice() {
        Map<String, String> all_orgs = SliceBase.getOrganizationMap();
        if (all_orgs == null || all_orgs.size() <= 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, String> entry : all_orgs.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    public static int reloadTime() {
        if (reloadTime == 0) {
            reloadTime = Integer.parseInt(EnviromentUtil.getProperty("efuture.slice.reload", "300"));
        }
        return reloadTime;
    }

    public static boolean isEnableSlice() {
        if (isEnableSlice == null) {
            isEnableSlice = "true".equalsIgnoreCase(EnviromentUtil.getProperty("efuture.slice.enable", "false"));
        }
        return isEnableSlice;
    }

    public static boolean isDebugLog() {
        if (isDebugLog == null) {
            isDebugLog = "true".equalsIgnoreCase(EnviromentUtil.getProperty("efuture.slice.debuglog", "false"));
        }
        return isDebugLog;
    }

    public static String getNoFindError() {
        if (noFindError == null && "true".equalsIgnoreCase(noFindError = EnviromentUtil.getProperty("efuture.slice.nofinderror", "true"))) {
            noFindError = "m$eventscopeitem";
        }
        return noFindError;
    }

    public boolean isNoFindErrorTable(String sqlStatement) {
        String err = SliceBase.getNoFindError();
        if (StringUtils.isEmpty((Object)err) || "false".equalsIgnoreCase(err)) {
            return false;
        }
        String[] ss = err.split(",");
        for (int i = 0; i < ss.length; ++i) {
            if (sqlStatement.indexOf(ss[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isParaTable(String sqlStatement) {
        for (String table : this.LIST_ParaTable) {
            if (sqlStatement.indexOf(table) <= 0) continue;
            return true;
        }
        return false;
    }

    protected static void sliceFilterLog(String logmsg, Object ... args) {
        if (SliceBase.isDebugLog()) {
            logger.info(logmsg, args);
        }
    }

    public static void setCurrentSlice(String slice) {
        ServiceRestReflect.getLocale().get().setSlice(slice);
    }

    public static String getCurrentSlice() {
        return ServiceRestReflect.getLocale().get().getSlice();
    }

    public static String getCurrentEntMarket() {
        return ServiceRestReflect.getLocale().get().getEntMarket();
    }

    static {
        isDebugLog = null;
        isEnableSlice = null;
        noFindError = null;
        reloadTime = 0;
    }

    public static interface SliceStatus {
        public static final String READ = "read";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
    }
}

