/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.sysevent;

import com.efuture.ocp.common.sysevent.SystemEvent;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationListener;

public abstract class SystemEventListener<E extends SystemEvent>
implements ApplicationListener<E> {
    protected Logger logger;

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.getClass().getName());
        }
        return this.logger;
    }

    protected void doneBeforeLog(E event) {
        this.getLogger().info((Object)String.format("[%s] event starting ...", ((SystemEvent)((Object)event)).getEventMsgTopic()));
    }

    protected void doneAfterLog(E event) {
        this.getLogger().info((Object)String.format("[%s] event finished ...", ((SystemEvent)((Object)event)).getEventMsgTopic()));
    }

    public void onApplicationEvent(E event) {
        this.doneBeforeLog(event);
        this.onEventDone(event);
        this.doneAfterLog(event);
    }

    protected abstract void onEventDone(E var1);
}

