/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.trigger;

import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.trigger.TbDeleteAfterTrigger;
import com.efuture.ocp.common.trigger.TbDeleteBeforeTrigger;
import com.efuture.ocp.common.trigger.TbInserAfterTrigger;
import com.efuture.ocp.common.trigger.TbInserBeforeTrigger;
import com.efuture.ocp.common.trigger.TbUpdateAfterTrigger;
import com.efuture.ocp.common.trigger.TbUpdateBeforeTrigger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TbTriggerFactory
implements ApplicationContextAware {
    private Map<String, TbInserAfterTrigger> inserAfterTriggerMap = new ConcurrentHashMap<String, TbInserAfterTrigger>();
    private Map<String, TbInserBeforeTrigger> inserBeforeTriggerMap = new ConcurrentHashMap<String, TbInserBeforeTrigger>();
    private Map<String, TbDeleteAfterTrigger> deleteAfterTriggerMap = new ConcurrentHashMap<String, TbDeleteAfterTrigger>();
    private Map<String, TbDeleteBeforeTrigger> deleteBeforeTriggerMap = new ConcurrentHashMap<String, TbDeleteBeforeTrigger>();
    private Map<String, TbUpdateAfterTrigger> updateAfterTriggerMap = new ConcurrentHashMap<String, TbUpdateAfterTrigger>();
    private Map<String, TbUpdateBeforeTrigger> updateBeforeTriggerMap = new ConcurrentHashMap<String, TbUpdateBeforeTrigger>();
    @Autowired
    Environment env;

    private String getDbtype() {
        String dbtype = this.env.getProperty("efuture.dataSource.mallpub.dbtype", "");
        return dbtype;
    }

    public void inserBefore(String tableName, AbstractEntityBean o) {
        TbInserBeforeTrigger trigger = this.inserBeforeTriggerMap.get(tableName.replaceAll("dbusrpub.", ""));
        if (trigger == null) {
            return;
        }
        if (!"mysql".equalsIgnoreCase(this.getDbtype())) {
            return;
        }
        trigger.beforeInsert(o);
    }

    public void inserAfter(String tableName, AbstractEntityBean o) {
        TbInserAfterTrigger trigger = this.inserAfterTriggerMap.get(tableName.replaceAll("dbusrpub.", ""));
        if (trigger == null) {
            return;
        }
        if (!"mysql".equalsIgnoreCase(this.getDbtype())) {
            return;
        }
        trigger.afterInsert(o);
    }

    public void updateBefore(String tableName, AbstractEntityBean oldRow, AbstractEntityBean newRow) {
        TbUpdateBeforeTrigger trigger = this.updateBeforeTriggerMap.get(tableName.replaceAll("dbusrpub.", ""));
        if (trigger == null) {
            return;
        }
        if (!"mysql".equalsIgnoreCase(this.getDbtype())) {
            return;
        }
        trigger.updateBeforetrigger(oldRow, newRow);
    }

    public void updateAfter(String tableName, AbstractEntityBean oldRow, AbstractEntityBean newRow) {
        TbUpdateAfterTrigger trigger = this.updateAfterTriggerMap.get(tableName.replaceAll("dbusrpub.", ""));
        if (trigger == null) {
            return;
        }
        if (!"mysql".equalsIgnoreCase(this.getDbtype())) {
            return;
        }
        trigger.aftertUpdate(oldRow, newRow);
    }

    public void deleteBefore(String tableName, AbstractEntityBean o) {
        TbDeleteBeforeTrigger trigger = this.deleteBeforeTriggerMap.get(tableName.replaceAll("dbusrpub.", ""));
        if (trigger == null) {
            return;
        }
        if (!"mysql".equalsIgnoreCase(this.getDbtype())) {
            return;
        }
        trigger.beforeDelete(o);
    }

    public void deleteAfter(String tableName, AbstractEntityBean o) {
        TbDeleteAfterTrigger trigger = this.deleteAfterTriggerMap.get(tableName.replaceAll("dbusrpub.", ""));
        if (trigger == null) {
            return;
        }
        if (!"mysql".equalsIgnoreCase(this.getDbtype())) {
            return;
        }
        trigger.afterDelete(o);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beansOfType = applicationContext.getBeansOfType(TbInserAfterTrigger.class);
        beansOfType.values().forEach(trigger -> {
            if (StringUtils.isEmpty((Object)trigger.getTbname())) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u5b9e\u73b0\u7c7b[" + trigger.getClass().getName() + "]\u7684\u8868\u540d\u79f0\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)this.inserAfterTriggerMap.get(trigger.getTbname()))) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u591a\u4e2a\u76f8\u540c\u7684\u8868\u540d\u79f0[" + trigger.getTbname() + "]\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b");
            }
            this.inserAfterTriggerMap.put(trigger.getTbname(), (TbInserAfterTrigger)trigger);
        });
        Map beansOfType2 = applicationContext.getBeansOfType(TbInserBeforeTrigger.class);
        beansOfType2.values().forEach(trigger -> {
            if (!StringUtils.isEmpty((Object)this.inserAfterTriggerMap.get(trigger.getTbname()))) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u591a\u4e2a\u76f8\u540c\u7684\u8868\u540d\u79f0[" + trigger.getTbname() + "]\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b");
            }
            this.inserBeforeTriggerMap.put(trigger.getTbname(), (TbInserBeforeTrigger)trigger);
        });
        Map beansOfType3 = applicationContext.getBeansOfType(TbDeleteAfterTrigger.class);
        beansOfType3.values().forEach(trigger -> {
            if (!StringUtils.isEmpty((Object)this.deleteAfterTriggerMap.get(trigger.getTbname()))) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u591a\u4e2a\u76f8\u540c\u7684\u8868\u540d\u79f0[" + trigger.getTbname() + "]\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b");
            }
            this.deleteAfterTriggerMap.put(trigger.getTbname(), (TbDeleteAfterTrigger)trigger);
        });
        Map beansOfType4 = applicationContext.getBeansOfType(TbDeleteBeforeTrigger.class);
        beansOfType4.values().forEach(trigger -> {
            if (!StringUtils.isEmpty((Object)this.deleteBeforeTriggerMap.get(trigger.getTbname()))) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u591a\u4e2a\u76f8\u540c\u7684\u8868\u540d\u79f0[" + trigger.getTbname() + "]\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b");
            }
            this.deleteBeforeTriggerMap.put(trigger.getTbname(), (TbDeleteBeforeTrigger)trigger);
        });
        Map beansOfType5 = applicationContext.getBeansOfType(TbUpdateAfterTrigger.class);
        beansOfType5.values().forEach(trigger -> {
            if (!StringUtils.isEmpty((Object)this.updateAfterTriggerMap.get(trigger.getTbname()))) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u591a\u4e2a\u76f8\u540c\u7684\u8868\u540d\u79f0[" + trigger.getTbname() + "]\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b");
            }
            this.updateAfterTriggerMap.put(trigger.getTbname(), (TbUpdateAfterTrigger)trigger);
        });
        Map beansOfType6 = applicationContext.getBeansOfType(TbUpdateBeforeTrigger.class);
        beansOfType6.values().forEach(trigger -> {
            if (!StringUtils.isEmpty((Object)this.updateBeforeTriggerMap.get(trigger.getTbname()))) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u6ce8\u5165\u53d1\u73b0\u591a\u4e2a\u76f8\u540c\u7684\u8868\u540d\u79f0[" + trigger.getTbname() + "]\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b");
            }
            this.updateBeforeTriggerMap.put(trigger.getTbname(), (TbUpdateBeforeTrigger)trigger);
        });
    }
}

