/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.calendar.Calendarist;
import com.efuture.ocp.common.calendar.pojo.CycleDate;
import com.efuture.ocp.common.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BirthdayUtils {
    public static BirthdayInfo getInfo(String birthtype, Date birthday) throws ParseException {
        return BirthdayUtils.doGetBirthdayInfo(birthtype, birthday);
    }

    public static BirthdayInfo getInfo(String birthtype, String birthday) throws ParseException {
        Date date = null;
        try {
            date = DateUtils.parseDate((String)birthday, (String[])new String[]{"yyyyMMdd"});
        }
        catch (ParseException e) {
            try {
                date = DateUtils.parseDate((String)birthday, (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return BirthdayUtils.doGetBirthdayInfo(birthtype, date);
    }

    private static Date intToDate(int[] array) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(array[0], array[1], array[2]);
        return calendar.getTime();
    }

    public static int getAgeByBirth(Date birthDay) throws ParseException {
        int age = 0;
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static BirthdayInfo doGetBirthdayInfo(String birthtype, Date birthday) throws ParseException {
        BirthdayInfo birthdayInfo = new BirthdayInfo();
        birthdayInfo.birthtype = birthtype;
        birthdayInfo.birthday = birthday;
        if ("1".equalsIgnoreCase(birthtype)) {
            birthdayInfo.solar = birthday;
            birthdayInfo.lunar = Calendarist.fromSolar(birthday).toLunar().getDate();
        } else {
            birthdayInfo.lunar = birthday;
            birthdayInfo.solar = Calendarist.fromLunar(birthday).toSolar().getDate();
        }
        CycleDate cycleDate = Calendarist.fromSolar(birthdayInfo.solar).toCycle();
        birthdayInfo.lunar_chn = cycleDate.getEraDate();
        birthdayInfo.animal = cycleDate.getZodiac();
        birthdayInfo.astro = Calendarist.fromSolar(birthdayInfo.solar).toSolar().getAstro();
        birthdayInfo.age = BirthdayUtils.getAgeByBirth(birthdayInfo.solar);
        return birthdayInfo;
    }

    public static void main(String[] args) {
        try {
            System.out.println(BirthdayUtils.doGetBirthdayInfo("1", new SimpleDateFormat("yyyy-MM-dd").parse("1978-10-28")).toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static class BirthdayInfo {
        int age;
        String astro;
        String animal;
        String birthtype;
        Date birthday;
        Date solar;
        Date lunar;
        String lunar_chn;

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getAstro() {
            return this.astro;
        }

        public void setAstro(String astro) {
            this.astro = astro;
        }

        public String getAnimal() {
            return this.animal;
        }

        public void setAnimal(String animal) {
            this.animal = animal;
        }

        public String getBirthtype() {
            return this.birthtype;
        }

        public void setBirthtype(String birthtype) {
            this.birthtype = birthtype;
        }

        public Date getBirthday() {
            return this.birthday;
        }

        public void setBirthday(Date birthday) {
            this.birthday = birthday;
        }

        public Date getSolar() {
            return this.solar;
        }

        public void setSolar(Date solar) {
            this.solar = solar;
        }

        public Date getLunar() {
            return this.lunar;
        }

        public void setLunar(Date lunar) {
            this.lunar = lunar;
        }

        public String getLunar_chn() {
            return this.lunar_chn;
        }

        public void setLunar_chn(String lunar_chn) {
            this.lunar_chn = lunar_chn;
        }

        public String toString() {
            return "BirthdayInfo{age=" + this.age + ", astro='" + this.astro + '\'' + ", animal='" + this.animal + '\'' + ", birthtype='" + this.birthtype + '\'' + ", birthday=" + this.birthday + ", solar=" + this.solar + ", lunar=" + this.lunar + ", lunar_chn='" + this.lunar_chn + '\'' + '}';
        }
    }

    public static interface BIRTH_TYPE {
        public static final String SOLAR = "1";
        public static final String LUNAR = "2";
    }
}

