/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

@Configuration
public class EnviromentUtil
implements EnvironmentAware {
    private static Environment environment;

    public void setEnvironment(Environment environment) {
        EnviromentUtil.environment = environment;
    }

    public static String getProperty(String key) {
        return environment.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        String propertyValue = environment.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            return defaultValue;
        }
        return propertyValue;
    }

    public static Environment getEnv() {
        return environment;
    }

    public static JSONObject followEnvironment(Environment env, String ... flow) {
        String envs = env != null ? env.getProperty("env.follow") : EnviromentUtil.getProperty("env.follow");
        JSONObject json = null;
        if (flow != null && flow.length > 0 || !StringUtils.isEmpty((CharSequence)envs)) {
            json = new JSONObject();
            System.out.println("============ Env properties follow start ===============");
            if (flow != null && flow.length > 0) {
                for (int i = 0; i < flow.length; ++i) {
                    String data = env != null ? env.getProperty(flow[i]) : EnviromentUtil.getProperty(flow[i]);
                    System.out.println(flow[i] + " : " + data);
                    json.put(flow[i], (Object)data);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)envs)) {
                String[] keys = envs.split(",");
                for (int i = 0; i < keys.length; ++i) {
                    String data = env != null ? env.getProperty(keys[i]) : EnviromentUtil.getProperty(keys[i]);
                    System.out.println(keys[i] + " : " + data);
                    json.put(keys[i], (Object)data);
                }
            }
            System.out.println("============ Env properties follow ends  ===============");
        }
        return json;
    }

    public static JSONObject getAllPropertys(String ... groups) {
        JSONObject json = new JSONObject();
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            for (PropertySource ps : env.getPropertySources()) {
                if ("systemProperties".equals(ps.getName()) || "systemEnvironment".equals(ps.getName()) || ps.getName().indexOf("applicationConfig") >= 0) continue;
                boolean ok = false;
                if (groups != null && groups.length > 0) {
                    for (String grp : groups) {
                        if (ps.getName().indexOf(grp) < 0) continue;
                        ok = true;
                        break;
                    }
                } else {
                    ok = true;
                }
                if (!ok || !(ps.getSource() instanceof Properties) && !(ps.getSource() instanceof LinkedHashMap)) continue;
                Map prop = (Map)ps.getSource();
                JSONObject jsn = new JSONObject();
                for (Object key : prop.keySet()) {
                    jsn.put(String.valueOf(key), prop.get(key));
                }
                json.put(ps.getName(), (Object)jsn);
            }
        }
        return json;
    }
}

