/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.calendar;

import com.efuture.ocp.common.calendar.base.ConvertFromType;
import com.efuture.ocp.common.calendar.core.CalendaristBase;
import com.efuture.ocp.common.calendar.core.convert.CalendaristConvert;
import com.efuture.ocp.common.calendar.pojo.CycleDate;
import com.efuture.ocp.common.calendar.pojo.LunarDate;
import com.efuture.ocp.common.calendar.pojo.SolarDate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Calendarist
extends CalendaristBase {
    public static Calendarist fromLunar(LunarDate lunarDate) {
        if (lunarDate == null) {
            throw new IllegalArgumentException("the argument 'lunarDate' must not be null");
        }
        return Calendarist.fromLunar(lunarDate.getYear(), lunarDate.getMonth(), lunarDate.getDay(), lunarDate.getHour(), lunarDate.getMinute(), lunarDate.getSecond(), lunarDate.getMillis(), lunarDate.isItsLeapMonth());
    }

    public static Calendarist fromLunar(int year, int month, int day) {
        return Calendarist.fromLunar(year, month, day, 0, 0, 0, 0);
    }

    public static Calendarist fromLunar(int year, int month, int day, int hour, int minute, int second, int millis) {
        return Calendarist.fromLunar(year, month, day, hour, minute, second, millis, false);
    }

    public static Calendarist fromLunar(int year, int month, int day, int hour, int minute, int second, int millis, boolean itsLeapMonth) {
        Calendarist.validate(year, month, day, hour, minute, second, millis);
        Calendarist calendarist = new Calendarist();
        calendarist.set(1, year);
        calendarist.set(2, month);
        calendarist.set(5, day);
        calendarist.set(11, hour);
        calendarist.set(12, minute);
        calendarist.set(13, second);
        calendarist.set(14, millis);
        calendarist.itsLeapMonth(itsLeapMonth);
        calendarist.setFrom(ConvertFromType.FROM_LUNAR);
        return calendarist;
    }

    public static Calendarist fromLunar(Date date) {
        return Calendarist.fromLunar(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), 0, 0, 0, 0);
    }

    public static Calendarist fromSolar(Long timeMillis) {
        if (timeMillis == null) {
            throw new IllegalArgumentException("the argument timemillis must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        return Calendarist.fromSolar(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static Calendarist fromSolar(SolarDate solarDate) {
        if (solarDate == null) {
            throw new IllegalArgumentException("the argument 'solarDate' must not be null");
        }
        return Calendarist.fromSolar(solarDate.getYear(), solarDate.getMonth(), solarDate.getDay(), solarDate.getHour(), solarDate.getMinute(), solarDate.getSecond(), solarDate.getMillis());
    }

    public static Calendarist fromSolar(int year, int month, int day) {
        return Calendarist.fromSolar(year, month, day, 0, 0, 0, 0);
    }

    public static Calendarist fromSolar(int year, int month, int day, int hour, int minute, int second, int millis) {
        Calendarist.validate(year, month, day, hour, minute, second, millis);
        Calendarist calendarist = new Calendarist();
        calendarist.set(1, year);
        calendarist.set(2, month);
        calendarist.set(5, day);
        calendarist.set(11, hour);
        calendarist.set(12, minute);
        calendarist.set(13, second);
        calendarist.set(14, millis);
        calendarist.setFrom(ConvertFromType.FROM_SOLAR);
        return calendarist;
    }

    public static Calendarist fromSolar(Date date) {
        return Calendarist.fromSolar(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), 0, 0, 0, 0);
    }

    public LunarDate toLunar() {
        return this.from == ConvertFromType.FROM_SOLAR ? CalendaristConvert.toLunar(this.toSolar().getTimestamp()) : new LunarDate(this.fields[1], this.fields[2], this.fields[5], this.fields[11], this.fields[12], this.fields[13], this.fields[14], this.fields[21] == 1);
    }

    public SolarDate toSolar() {
        return this.from == ConvertFromType.FROM_SOLAR ? new SolarDate(this.fields[1], this.fields[2], this.fields[5], this.fields[11], this.fields[12], this.fields[13], this.fields[14]) : CalendaristConvert.toSolar(this.toLunar());
    }

    public CycleDate toCycle() {
        return CalendaristConvert.toCycle(this.toLunar());
    }

    public static void main(String[] args) {
        Calendar ca = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ca.set(2020, 0, 1);
        do {
            Calendarist calendarist = Calendarist.fromSolar(ca.get(1), ca.get(2) + 1, ca.get(5), 12, 0, 0, 0);
            LunarDate lunarDate = calendarist.toLunar();
            SolarDate solarDate = calendarist.toSolar();
            CycleDate cycleDate = calendarist.toCycle();
            System.out.println(solarDate.toString());
            System.out.println(lunarDate.toString());
            System.out.println(cycleDate.toString());
            ca.add(5, 1);
        } while (ca.getTime().compareTo(new Date()) <= 0);
    }
}

