/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.fileio;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.fileio.DataImportConfigBean;
import com.efuture.ocp.common.fileio.DataImportConfigServiceImpl;
import com.efuture.ocp.common.fileio.FileImportService;
import com.efuture.ocp.common.fileio.ImportLogBean;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FStorageOperations;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class FileImportSrvl
extends BasicComponentService
implements FileImportService {
    private static final String STATIC_XLS = "XLS";
    private static final String STATIC_XLSX = "XLSX";
    private static final String SimpleDateFormat = null;
    private SXSSFWorkbook xlsx = null;
    private HSSFWorkbook xls = null;
    private String createfilepath = null;

    public String getCreatefilepath() {
        return this.createfilepath;
    }

    public void setCreatefilepath(String createfilepath) {
        this.createfilepath = createfilepath;
    }

    @Override
    public ServiceResponse getConfig(ServiceSession session, JSONObject jsonparam) throws Exception {
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        return dataImportConfig.search(session, jsonparam);
    }

    @Override
    public JSONObject beforeFileImport(ServiceSession session, JSONObject jsonparam, List<FileImportObject> list) throws Exception {
        long starttime = System.currentTimeMillis();
        this.getLogger().info((Object)("import start: " + starttime));
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"eid"))) {
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"billmoduleid"))) {
                jsonparam.put("eid", jsonparam.get((Object)"billmoduleid"));
            } else {
                throw new ServiceException("10000", "{0} or {1} does not exist", "eid", "billmoduleid");
            }
        }
        String filepath = this.savefile(session, list);
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        DataImportConfigBean exportConfig = dataImportConfig.getConfig(session.getEnt_id(), jsonparam.getString("eid"), null);
        if (exportConfig == null) {
            throw new ServiceException("10000", "{0}\u6a21\u5757\u5bfc\u5165\u914d\u7f6e\u4e0d\u5b58\u5728", jsonparam.get((Object)"eid"));
        }
        String impfields = exportConfig.getImpfields();
        String imptype = exportConfig.getEid();
        long maxrow = -1L;
        this.checkConfig(exportConfig);
        this.getLogger().info((Object)("import start: " + starttime + " imptype: " + imptype));
        JSONObject jsonconfig = (JSONObject)Utils.toNormalJSONObject(exportConfig);
        JSONArray errList = new JSONArray();
        JSONArray successList = new JSONArray();
        JSONArray ary = null;
        JSONArray array = null;
        String filename = "";
        for (FileImportObject fio : list) {
            filename = new String(fio.getFilename().getBytes("iso-8859-1"));
            ary = filename.toLowerCase().endsWith(".xlsx") ? ExcelUtils.XLSXtoJSONArray(fio.getStream(), impfields, maxrow) : ExcelUtils.XLStoJSONArray(fio.getStream(), impfields, maxrow);
            if (array != null) {
                array.addAll((Collection)ary);
                continue;
            }
            array = ary;
        }
        array = this.impToRegular(array);
        this.checkStyle(array, jsonconfig, successList, errList);
        array = successList.clone();
        successList.clear();
        JSONObject out = new JSONObject();
        if (array.size() > 0) {
            out.put("imparray", (Object)array);
        }
        if (errList.size() > 0) {
            out.put("errList", (Object)errList);
        }
        out.put("filename", (Object)filename);
        out.put("filepath", (Object)filepath);
        out.put("impconfig", (Object)jsonconfig);
        return out;
    }

    public String savefile(ServiceSession session, List<FileImportObject> list) throws Exception {
        ArrayList<FileImportObject> newList = new ArrayList<FileImportObject>();
        for (FileImportObject fio : list) {
            int len;
            FileImportObject newfio = new FileImportObject();
            newfio.setFilename(fio.getFilename());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fio.getStream().read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            fio.setStream(new ByteArrayInputStream(baos.toByteArray()));
            newfio.setStream(new ByteArrayInputStream(baos.toByteArray()));
            newList.add(newfio);
        }
        String filepath = "";
        for (FileImportObject fio : newList) {
            filepath = this.writeToLocal(fio.getFilename(), fio.getStream());
        }
        return filepath;
    }

    public String writeToLocal(String filename, InputStream input) throws IOException {
        String filePath = this.getFilePath();
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String tempExcelFile = filePath + sdfymdCard.format(new Date());
        tempExcelFile = filename.toUpperCase().endsWith(STATIC_XLSX) ? tempExcelFile + ".xlsx" : (filename.toUpperCase().endsWith(STATIC_XLS) ? tempExcelFile + ".xls" : tempExcelFile + ".xls");
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        in = new BufferedInputStream(input);
        out = new BufferedOutputStream(new FileOutputStream(tempExcelFile));
        int len = -1;
        byte[] b = new byte[1024];
        while ((len = in.read(b)) != -1) {
            out.write(b, 0, len);
        }
        in.close();
        out.close();
        return tempExcelFile;
    }

    public void checkConfig(DataImportConfigBean config) throws Exception {
        String impfields = config.getImpfields();
        String impname = config.getImpfields_name();
        String imptype = config.getImpfields_datatype();
        String defaultparam = config.getDefaultparam();
        String defaultvalue = config.getDefaultvalue();
        if (StringUtils.isEmpty((Object)impfields) || StringUtils.isEmpty((Object)impname) || StringUtils.isEmpty((Object)imptype)) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:impfields\u3001impfields_name\u3001impfields_datatype \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (impfields.split(",").length != impname.split(",").length) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:impfields\u3001impfields_name \u4e0d\u5339\u914d", new Object[0]);
        }
        if (impfields.split(",").length != imptype.split(",").length) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:impfields\u3001impfields_datatype \u4e0d\u5339\u914d", new Object[0]);
        }
        if (!StringUtils.isEmpty((Object)defaultparam) && defaultparam.split(",").length != defaultvalue.split(",").length) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:defaultparam\u3001defaultvalue \u4e0d\u5339\u914d", new Object[0]);
        }
    }

    public boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    private boolean isLong(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

    public boolean isequal(Object value1, Object value2) {
        return (value1 == null ? "" : value1.toString().trim()).equals(value2 == null ? "" : value2.toString().trim());
    }

    public String geterr(JSONArray array) {
        Object errmsg = "";
        for (int i = 0; i < array.size(); ++i) {
            JSONObject errrow = array.getJSONObject(i);
            errmsg = i == array.size() - 1 ? (String)errmsg + (String)(StringUtils.isEmpty((Object)errrow.get((Object)"column")) ? "" : "[" + errrow.getString("column") + "] ") + errrow.getString("msg") : (String)errmsg + (String)(StringUtils.isEmpty((Object)errrow.get((Object)"column")) ? "" : "[" + errrow.getString("column") + "] ") + errrow.getString("msg") + ",";
        }
        return errmsg;
    }

    public String checkRow(JSONObject row, JSONObject jsonparam, JSONArray array) throws Exception {
        String field;
        int i;
        JSONArray result = new JSONArray();
        String fields = jsonparam.getString("impfields");
        String fields_name = jsonparam.getString("impfields_name");
        String fields_type = jsonparam.getString("impfields_datatype");
        String fields_nonull = this.getParamWithCheck(jsonparam, "uniquecolumn", false, "") + "," + this.getParamWithCheck(jsonparam, "nonullfields", false, "");
        String field_norepeat = this.getParamWithCheck(jsonparam, "uniquecolumn", false, "") + "," + this.getParamWithCheck(jsonparam, "norepeatfields", false, "");
        String defaultparam = this.getParamWithCheck(jsonparam, "defaultparam", false, "");
        String defaultvalue = this.getParamWithCheck(jsonparam, "defaultvalue", false, "");
        String[] columns = fields.split(",");
        String[] columns_name = fields_name.split(",");
        String[] columns_type = fields_type.split(",");
        String[] columns_nonull = fields_nonull.split(",");
        String[] columns_norepeat = field_norepeat.split(",");
        String[] arr_defaultparam = defaultparam.split(",");
        String[] arr_defaultvalue = defaultvalue.split(",");
        boolean ibemptyline = true;
        for (i = 0; i < columns.length; ++i) {
            field = columns[i];
            if (StringUtils.isEmpty((Object)row.get((Object)field))) continue;
            ibemptyline = false;
            break;
        }
        if (ibemptyline) {
            JSONObject result_row = new JSONObject();
            result_row.put("msg", (Object)"is empty line");
            result.add((Object)result_row);
            return this.geterr(result);
        }
        for (i = 0; i < columns.length; ++i) {
            field = columns[i];
            String field_name = columns_name[i];
            JSONObject result_row = new JSONObject();
            result_row.put("column", (Object)field_name);
            if (field.equals("")) continue;
            for (String column_nonull : columns_nonull) {
                if (column_nonull.equals("") || !field.equals(column_nonull)) continue;
                if (row.get((Object)field) == null) {
                    result_row.put("msg", (Object)"is null");
                    result.add((Object)result_row);
                }
                if (!row.getString(field).trim().equals("")) continue;
                result_row.put("msg", (Object)"is null");
                result.add((Object)result_row);
            }
            if (row.get((Object)field) != null) {
                for (String nonull_fie : columns_nonull) {
                    if (!field.equals(nonull_fie)) continue;
                    if (columns_type[i].equals("D")) {
                        if (this.isDate(row.getString(field).trim())) continue;
                        result_row.put("msg", (Object)"format is wrong");
                        result.add((Object)result_row);
                        continue;
                    }
                    if (columns_type[i].equals("N")) {
                        if (this.isNumber(row.getString(field).trim())) continue;
                        result_row.put("msg", (Object)"format is wrong");
                        result.add((Object)result_row);
                        continue;
                    }
                    if (!columns_type[i].equals("L") || this.isLong(row.getString(field).trim())) continue;
                    result_row.put("msg", (Object)"format is wrong");
                    result.add((Object)result_row);
                }
                continue;
            }
            result_row.put("msg", (Object)"format is wrong");
            result.add((Object)result_row);
        }
        for (String column_repeat : columns_norepeat) {
            if (column_repeat.equals("")) continue;
            JSONObject result_row = new JSONObject();
            String[] column_r = column_repeat.split("#");
            Object column_name = "";
            for (String column : column_r) {
                for (int i2 = 0; i2 < columns.length; ++i2) {
                    if (!column.equals(columns[i2])) continue;
                    column_name = column == column_r[column_r.length - 1] ? (String)column_name + columns_name[i2] : (String)column_name + columns_name[i2] + ",";
                }
            }
            result_row.put("column", column_name);
            int isrepeat = 0;
            for (int j = 0; j < array.size(); ++j) {
                int isrepeat_row = 0;
                JSONObject json_row = array.getJSONObject(j);
                for (String column : column_r) {
                    if (!this.isequal(row.get((Object)column), json_row.getString(column))) continue;
                    ++isrepeat_row;
                }
                if (isrepeat_row != column_r.length) continue;
                ++isrepeat;
            }
            if (isrepeat <= true) continue;
            result_row.put("msg", (Object)"is repeat");
            result.add((Object)result_row);
        }
        for (int i3 = 0; i3 < arr_defaultparam.length; ++i3) {
            String paramrow = arr_defaultparam[i3].trim();
            if (paramrow.equals("") || !StringUtils.isEmpty((Object)row.get((Object)paramrow))) continue;
            row.put(paramrow, (Object)arr_defaultvalue[i3]);
        }
        String flag = "Y";
        if (result.size() > 0) {
            flag = this.geterr(result);
        }
        return flag;
    }

    public void checkStyle(JSONArray array, JSONObject jsonparam, JSONArray successList, JSONArray errList) throws Exception {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json_row = array.getJSONObject(i);
            String flag = this.checkRow(json_row, jsonparam, array);
            if (flag.equals("Y")) {
                successList.add((Object)json_row);
                continue;
            }
            if (flag.equals("is empty line")) continue;
            json_row.put("errmsg", (Object)flag);
            errList.add((Object)json_row);
        }
    }

    public Object colTotrim(Object colvalue) {
        if (colvalue == null) {
            return null;
        }
        if (colvalue.toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
        if (pattern.matcher(colvalue.toString()).matches()) {
            return colvalue;
        }
        return colvalue.toString().trim();
    }

    public Object colTocleanpoint(Object colvalue) {
        if (colvalue == null) {
            return null;
        }
        if (this.isNumber(colvalue.toString()) && colvalue.toString().indexOf(".") > 0 && Double.parseDouble(colvalue.toString()) == Double.parseDouble(colvalue.toString().substring(0, colvalue.toString().indexOf(".")))) {
            return colvalue.toString().substring(0, colvalue.toString().indexOf("."));
        }
        return colvalue;
    }

    public JSONArray impToRegular(JSONArray array) {
        JSONArray newarray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = new JSONObject((Map)array.getJSONObject(i));
            Set keys = item.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String keyname = iterator.next().toString();
                item.put(keyname, this.colTocleanpoint(this.colTotrim(item.get((Object)keyname))));
            }
            newarray.add((Object)item);
        }
        return newarray;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void doResponseServiceImp(ServiceSession session, String eid, String method, JSONObject impdata, JSONArray successList, JSONArray errList) throws Exception {
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest(session, method, impdata.toJSONString());
        if (resp.getReturncode().equals("0")) {
            JSONObject jsonout = (JSONObject)resp.getData();
            errList.addAll((Collection)jsonout.getJSONArray("errList"));
            successList.addAll((Collection)jsonout.getJSONArray("successList"));
        }
    }

    public String downloadTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        String modulecode = jsonparam.getString("billmoduleid");
        this.getLogger().info((Object)("\u4e0b\u8f7d\u5bfc\u5165\u6a21\u7248\uff0c" + modulecode + ",start...."));
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        List<DataImportConfigBean> importconfigbean = dataImportConfig.getConfigByModule(session.getEnt_id(), modulecode);
        if (importconfigbean.size() <= 0) {
            throw new ServiceException("10000", "\u6a21\u5757[{0}]\u5bfc\u5165\u914d\u7f6e\u4e0d\u5b58\u5728", modulecode);
        }
        String exceltype = null;
        exceltype = StringUtils.isEmpty((Object)jsonparam.get((Object)"filetype")) ? STATIC_XLSX : ("1".equals(excel = jsonparam.get((Object)"filetype").toString()) ? STATIC_XLS : STATIC_XLSX);
        ArrayList<String> filelist = new ArrayList<String>();
        if (importconfigbean.size() > 1) {
            int i = 0;
            for (DataImportConfigBean row : importconfigbean) {
                String[] fldlst = row.getImpfields().split(",");
                String[] disps = row.getImpfields_name().split(",");
                Object tempfileName = "";
                tempfileName = row.getEname() + (String)tempfileName + ++i;
                String file = this.createExcel((String)tempfileName, fldlst, disps, exceltype);
                filelist.add(file);
            }
        } else {
            String[] fldlst = importconfigbean.get(0).getImpfields().split(",");
            String[] disps = importconfigbean.get(0).getImpfields_name().split(",");
            Object tempfileName = "";
            tempfileName = importconfigbean.get(0).getEname() + (String)tempfileName;
            String file = this.createExcel((String)tempfileName, fldlst, disps, exceltype);
            filelist.add(file);
        }
        String reFile = "";
        reFile = filelist.size() > 1 ? this.makezip(filelist) : (String)filelist.get(0);
        return reFile;
    }

    public String getFilePath() {
        String osname = System.getProperties().getProperty("os.name");
        String head = this.createfilepath;
        if (osname.startsWith("Windows")) {
            head = "D:\\file\\";
            File dir = new File(head);
            if (!dir.exists() && !dir.mkdirs()) {
                head = "C:\\file\\";
            }
        } else {
            File dir;
            if (StringUtils.isEmpty((Object)head)) {
                head = "/opt/file/";
            }
            if (!(dir = new File(head)).exists()) {
                dir.mkdirs();
            }
        }
        return head;
    }

    public String makezip(List<String> filelist) throws IOException {
        String trackkey;
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = trackkey = sdfymdCard.format(new Date());
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < filelist.size(); ++i) {
            File file = new File(filelist.get(i));
            files.add(file);
        }
        String head = this.getFilePath();
        String name = head + filename + ".rar";
        File file = new File(name);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fous = new FileOutputStream(file);
        ZipOutputStream zipOut = new ZipOutputStream(fous);
        this.zipFile(files, zipOut);
        zipOut.close();
        fous.close();
        for (File temp : files) {
            if (!temp.isFile() || !temp.exists()) continue;
            temp.delete();
        }
        return name;
    }

    private void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            this.zipFile(file, outputStream);
        }
    }

    private void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void exportDataToExcel(String[] fldlst, String[] disps, String exceltype) {
        SXSSFSheet sheet = null;
        CellStyle columnHeadStyle = null;
        CellStyle cellStyle = null;
        Font f = null;
        if (fldlst == null) {
            fldlst = "".split(",");
        }
        if (disps == null) {
            disps = "".split(",");
        }
        DataFormat format = null;
        if (STATIC_XLSX.equals(exceltype)) {
            columnHeadStyle = this.xlsx.createCellStyle();
            format = this.xlsx.createDataFormat();
            f = this.xlsx.createFont();
            sheet = this.xlsx.createSheet("Sheet1");
            cellStyle = this.xlsx.createCellStyle();
        } else {
            columnHeadStyle = this.xls.createCellStyle();
            format = this.xls.createDataFormat();
            f = this.xls.createFont();
            sheet = this.xls.createSheet("Sheet1");
            cellStyle = this.xls.createCellStyle();
        }
        columnHeadStyle.setBorderBottom(BorderStyle.THIN);
        columnHeadStyle.setBorderLeft(BorderStyle.THIN);
        columnHeadStyle.setBorderRight(BorderStyle.THIN);
        columnHeadStyle.setBorderTop(BorderStyle.THIN);
        columnHeadStyle.setAlignment(HorizontalAlignment.CENTER);
        columnHeadStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        columnHeadStyle.setWrapText(true);
        f.setFontHeightInPoints((short)9);
        f.setBold(true);
        columnHeadStyle.setFont(f);
        columnHeadStyle.setDataFormat(format.getFormat("@"));
        Row row = sheet.createRow(0);
        sheet.createFreezePane(0, 1, 0, 1);
        int i = 0;
        for (String s : fldlst) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(columnHeadStyle);
            cell.setCellValue(disps[i]);
            sheet.setColumnWidth(i, 7000);
            sheet.setDefaultColumnStyle(i, columnHeadStyle);
            ++i;
        }
    }

    protected void setCellsValueTyle(Cell cell, Object obj, String style, CellStyle cellStyle) {
        if (obj != null) {
            if (obj instanceof Date) {
                if (StringUtils.isEmpty((Object)style)) {
                    style = "yyyy-MM-dd";
                }
                SimpleDateFormat sdfymdCard = new SimpleDateFormat(style);
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(sdfymdCard.format(obj));
            } else if (obj instanceof Integer || obj instanceof Long || obj instanceof Short) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                cell.setCellStyle(cellStyle);
                DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
                df.setMaximumFractionDigits(0);
                cell.setCellValue(df.format(obj));
            } else if (obj instanceof Double || obj instanceof Float) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                cell.setCellStyle(cellStyle);
                DecimalFormat df2 = (DecimalFormat)DecimalFormat.getInstance();
                if (StringUtils.isEmpty((Object)style)) {
                    style = "n2";
                }
                if (style.startsWith("n")) {
                    Integer p = Integer.valueOf(style.substring(style.length() - 1, style.length()));
                    StringBuffer sb = new StringBuffer();
                    if (p == 0) {
                        sb.append("0");
                    } else {
                        sb.append("0.");
                        for (int j = 0; j < p; ++j) {
                            sb.append("0");
                        }
                    }
                    df2.setGroupingSize(3);
                    df2.applyPattern(sb.toString());
                    cell.setCellValue(df2.format(obj));
                } else if (style.startsWith("p")) {
                    DecimalFormat df3 = (DecimalFormat)DecimalFormat.getInstance();
                    df3.applyPattern("##.##%");
                    cell.setCellValue(df3.format(obj));
                }
            } else {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                cellStyle.setWrapText(true);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(obj.toString());
            }
        } else {
            cell.setCellStyle(cellStyle);
            cell.setCellValue("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createExcel(String fileName, String[] fldlst, String[] disps, String exceltype) throws Exception {
        String filePath = this.getFilePath();
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Object tempExcelFile = "";
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        fileName = (String)fileName + sdfymdCard.format(new Date());
        tempExcelFile = STATIC_XLSX.equals(exceltype) ? filePath + (String)fileName + ".xlsx" : filePath + (String)fileName + ".xls";
        int rowMemory = 100;
        FileOutputStream fos = new FileOutputStream((String)tempExcelFile);
        if (STATIC_XLSX.equals(exceltype)) {
            try {
                this.xlsx = new SXSSFWorkbook(rowMemory);
                this.exportDataToExcel(fldlst, disps, STATIC_XLSX);
                this.xlsx.write((OutputStream)fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();
            }
        }
        try {
            this.xls = new HSSFWorkbook();
            this.exportDataToExcel(fldlst, disps, STATIC_XLS);
            this.xls.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        finally {
            fos.flush();
            fos.close();
        }
        return tempExcelFile;
    }

    public void savelog(ServiceSession session, JSONObject jsonparam) throws Exception {
        ImportLogBean implog = (ImportLogBean)JSON.toJavaObject((JSON)jsonparam, ImportLogBean.class);
        implog.setPh_key(UniqueID.getUniqueID());
        implog.setPh_timestamp(new Date());
        implog.setEnt_id(session.getEnt_id());
        this.getStorageOperations().insert((Object)implog);
    }

    public String downFile(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (jsonparam.containsKey((Object)"client")) {
            String url = "http://".concat(jsonparam.getString("client"));
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"url"))) {
                url = url.concat(jsonparam.getString("url"));
            }
            JSONObject json = (JSONObject)jsonparam.clone();
            json.remove((Object)"client");
            json.remove((Object)"url");
            return this.getRequest(session, url, json);
        }
        String path = jsonparam.getString("filepath");
        return path;
    }

    private String postRequest(ServiceSession session, String url, JSONObject para) throws Exception {
        String FullUrl = url;
        FullUrl = FullUrl.concat("&").concat("param=%7B%22filepath%22:%22//opt//efuture//tmp//%E4%B8%8B%E8%BD%BD%E6%96%87%E4%BB%B6%E6%A1%88%E4%BE%8B.xlsx%22,%22url%22:%22/omp-work-webin/exportbyfile?method=omp.work.fileimport.downFile%22,%22modulecode%22:%226001230%22%7D");
        this.getLogger().info((Object)"\u8bf7\u6c42:".concat(url).concat(":").concat(para.toString()));
        String ret = "";
        try {
            ret = HttpUtils.postRequest(FullUrl, para.toJSONString(), "UTF-8");
        }
        catch (Exception ex) {
            throw new Exception("\u8bf7\u6c42\u9519\u8bef:".concat(url).concat(":").concat(para.toString()).concat(" ---error:").concat(ex.getMessage()));
        }
        this.getLogger().info((Object)"RES:".concat(ret));
        return ret;
    }

    private String getRequest(ServiceSession session, String url, JSONObject para) throws Exception {
        String FullUrl = url;
        JSONObject param = new JSONObject();
        param.put("param", (Object)para);
        String ParaList = HttpUtils.getFullURL(param);
        ParaList = URLEncoder.encode(ParaList, "UTF-8");
        ParaList = ParaList.replace("param%3D", "param=");
        FullUrl = FullUrl.concat("&").concat(ParaList);
        this.getLogger().info((Object)"GET\u8bf7\u6c42:".concat(FullUrl));
        String ret = HttpUtils.getRequest(FullUrl);
        this.getLogger().info((Object)"RES\u8fd4\u56de:".concat(ret));
        return ret;
    }

    public ServiceResponse searchimportlog(ServiceSession session, JSONObject jsonparam) throws Exception {
        FStorageOperations fso = this.getStorageOperations();
        jsonparam.put("ent_id", (Object)session.getEnt_id());
        JSONObject param = (JSONObject)jsonparam.clone();
        for (String key : jsonparam.keySet()) {
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)key))) continue;
            param.remove((Object)key);
        }
        StringBuffer total = new StringBuffer();
        List<Object> list = null;
        list = StringUtils.isEmpty((Object)param.get((Object)"fields")) ? this.doSearch(param, ImportLogBean.class, total) : this.doSearchForMap(param, ImportLogBean.class, total);
        JSONObject respdata = new JSONObject();
        respdata.put("total_results", (Object)Long.parseLong(total.toString()));
        respdata.put("importlog", list);
        return ServiceResponse.buildSuccess(respdata);
    }

    @Override
    public List<Map<String, Object>> getOutStyle() throws Exception {
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        return dataImportConfig.getOutConfigAll();
    }

    static interface separator {
        public static final String array = ",";
        public static final String field = "#";
    }

    static interface errCode {
        public static final String TYPE = "format is wrong";
        public static final String ISNULL = "is null";
        public static final String ISREPEAT = "is repeat";
        public static final String ISEMPTYLINE = "is empty line";
    }
}

