/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.log.StaticLog;
import com.efuture.ocp.common.task.TaskRepository;
import com.efuture.ocp.common.task.impl.DbTaskRepositoryImpl;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class TaskPublic {
    private static final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private static TaskRepository taskRepo;
    private static final Snowflake ID;

    public static DataSource getTaskDs() {
        if (dataSourceMap.get("taskDs") != null) {
            return dataSourceMap.get("taskDs");
        }
        String taskDsName = "taskDS";
        return SpringBeanFactory.getBean(taskDsName, DataSource.class);
    }

    public static void setTaskDs(DataSource taskDs) {
        dataSourceMap.put("taskDs", taskDs);
    }

    public static void setDs(String dsName, DataSource ds) {
        dataSourceMap.put(dsName, ds);
    }

    public static DataSource getDs(String dsName) {
        DataSource ds = dataSourceMap.get(dsName);
        if (ds == null && (ds = SpringBeanFactory.getBean(dsName, DataSource.class)) == null) {
            throw new RuntimeException("\u6ca1\u6709\u521b\u5efa" + dsName + "\u6570\u636e\u6e90");
        }
        return ds;
    }

    public static TaskRepository getTaskRepo() {
        if (taskRepo != null) {
            return taskRepo;
        }
        String repoName = "defaultTaskRepo";
        try {
            taskRepo = SpringBeanFactory.getBean(repoName, TaskRepository.class);
        }
        catch (Throwable th) {
            StaticLog.info((String)"\u672a\u627e\u5230defaultTaskRepo,\u4f7f\u7528\u9ed8\u8ba4\u7684\u5b9e\u73b0", (Object[])new Object[0]);
            taskRepo = new DbTaskRepositoryImpl();
        }
        return taskRepo;
    }

    public static void setTaskRepo(TaskRepository taskRepo) {
        TaskPublic.taskRepo = taskRepo;
    }

    public static long createExecId() {
        return ID.nextId();
    }

    static {
        ID = IdUtil.getSnowflake((long)3L, (long)3L);
    }

    public static interface TASK_TYPE {
        public static final String DAY_INIT = "DAY_INIT";
        public static final String DAY_END = "DAY_END";
    }
}

