/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.task;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.efuture.ocp.common.rest.ServiceLogs;
import java.text.MessageFormat;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public class TaskLog {
    private static Consumer<String> baseLog;

    public static Consumer<String> getBaseLog() {
        return baseLog;
    }

    public static void setBaseLog(Consumer<String> baseLog) {
        TaskLog.baseLog = baseLog;
    }

    private static void logBase(String msg) {
        TaskLog.logBase("taskLog", msg);
    }

    private static void logBase(String logType, String msg) {
        if (null == TaskLog.getBaseLog()) {
            ServiceLogs.debuglog(logType, msg, 0L);
        } else {
            TaskLog.getBaseLog().accept(msg);
        }
    }

    private static void logThrowable(Throwable th) {
        if (th == null) {
            return;
        }
        TaskLog.logBase(ExceptionUtil.stacktraceToString((Throwable)th));
    }

    public static void log(boolean throwRuntime, long startTime, Throwable th, String appendLogPattern, Object ... appendLogArguments) {
        Object elapsed = "";
        if (startTime > 0L) {
            long e = System.currentTimeMillis() - startTime;
            elapsed = "[\u8017\u65f6]" + e + " ";
        }
        Object msg = TaskLog.format(appendLogPattern, appendLogArguments);
        msg = (String)elapsed + (String)msg;
        TaskLog.logBase((String)msg);
        TaskLog.logThrowable(th);
        if (throwRuntime) {
            throw new RuntimeException((String)msg);
        }
    }

    public static void info(long starttime, String appendLogPattern, Object ... appendLogArguments) {
        TaskLog.log(false, 0L, null, appendLogPattern, appendLogArguments);
    }

    public static void error(Throwable th, String appendLogPattern, Object ... appendLogArguments) {
        TaskLog.log(false, 0L, th, appendLogPattern, appendLogArguments);
    }

    public static void error(String appendLogPattern, Object ... appendLogArguments) {
        TaskLog.log(false, 0L, null, appendLogPattern, appendLogArguments);
    }

    public static void errorAndThrowRuntime(Throwable th, String appendLogPattern, Object ... appendLogArguments) {
        TaskLog.log(true, 0L, th, appendLogPattern, appendLogArguments);
    }

    public static void debug(long starttime, String appendLogPattern, Object ... appendLogArguments) {
        TaskLog.log(false, 0L, null, appendLogPattern, appendLogArguments);
    }

    public static String format(String msg, Object ... args) {
        if (args == null || args.length <= 0) {
            return msg;
        }
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = StringUtils.isEmpty((Object)args[i]) ? "" : args[i].toString();
        }
        return MessageFormat.format(msg, args);
    }
}

