/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.datarange;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.datarange.DataRangeService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.OcpApplicationContext;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.user.DataRange;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="datarange_service")
public class DataRangeServiceImpl
implements DataRangeService {
    private int MAX_DATARANGE_NUM = 40;
    public static final String DRMODE_ALL = "all";
    public static final String DRMODE_IN = "indatarange";
    public static final String DRMODE_NON = "nodatarange";
    public static final String DRMODE_NONWHERE = " 1=2 ";
    public static final String DRMODE_ALLWHERE = " 1=1 ";
    public static final String DATARANGE_KEY = "OCP:DR:";
    @Autowired
    BatchInsService batchIns;

    public static DataRangeServiceImpl getInstance() {
        return SpringBeanFactory.getBean("datarange_service", DataRangeServiceImpl.class);
    }

    public List<Map<String, Object>> getTreeSub(List<Map<String, Object>> listin, String queryvale, String colCurrent, String colParent) throws Exception {
        ArrayList<Map<String, Object>> listout = new ArrayList<Map<String, Object>>();
        this.getTreeSub(listin, listout, queryvale, colCurrent, colParent);
        return listout;
    }

    public void getTreeSub(List<Map<String, Object>> listin, List<Map<String, Object>> listout, String queryvale, String colCurrent, String colParent) throws Exception {
        int len = listin.size();
        for (int i = 0; i < len; ++i) {
            if (!listin.get(i).get(colParent).toString().equals(queryvale)) continue;
            listout.add(listin.get(i));
            this.getTreeSub(listin, listout, listin.get(i).get(colCurrent).toString(), colCurrent, colParent);
        }
    }

    public Map<String, Object> getdep(List<Map<String, Object>> alldep, String depid) {
        for (Map<String, Object> dep : alldep) {
            if (!dep.get("deptid").toString().equals(depid)) continue;
            return dep;
        }
        return null;
    }

    private void insdatarangebymuid(FMybatisTemplate db, List<Map<String, Object>> alldep, Map<String, Object> postinfo) throws Exception {
        String murange = (String)postinfo.get("murange");
        String depid = (String)postinfo.get("deptid");
        Map<String, Object> thisdep = this.getdep(alldep, depid);
        postinfo.put("drkey", "mktid");
        db.getSqlSessionTemplate().delete("del_postdatarangedata", postinfo);
        if (murange.equalsIgnoreCase("1")) {
            ArrayList listinsert = new ArrayList();
            if (thisdep.get("MFTYPECODE").toString().equals("M")) {
                HashMap<String, String> insmap = new HashMap<String, String>();
                insmap.put("entid", postinfo.get("entid").toString());
                insmap.put("postid", postinfo.get("postid").toString());
                insmap.put("drkey", "mktid");
                insmap.put("dataid", thisdep.get("deptid").toString());
                insmap.put("datacode", thisdep.get("deptcode").toString());
                listinsert.add(insmap);
            } else if (thisdep.get("Muid") != null && !thisdep.get("Muid").equals("")) {
                HashMap<String, String> insmap = new HashMap<String, String>();
                insmap.put("entid", postinfo.get("entid").toString());
                insmap.put("postid", postinfo.get("postid").toString());
                insmap.put("drkey", "mktid");
                Map<String, Object> mkt = this.getdep(alldep, thisdep.get("Muid").toString());
                insmap.put("dataid", mkt.get("deptid").toString());
                insmap.put("datacode", mkt.get("deptcode").toString());
                listinsert.add(insmap);
            } else if (thisdep.get("treelevel").toString().equals("1") || thisdep.get("deptcode").toString().equals("001") || thisdep.get("treelevel").toString().equals("2")) {
                HashMap<String, String> insmap = new HashMap<String, String>();
                insmap.put("entid", postinfo.get("entid").toString());
                insmap.put("postid", postinfo.get("postid").toString());
                insmap.put("drkey", "mktid");
                insmap.put("dataid", DRMODE_ALL);
                insmap.put("datacode", DRMODE_ALL);
                listinsert.add(insmap);
            } else {
                HashMap<String, String> insmap = new HashMap<String, String>();
                insmap.put("entid", postinfo.get("entid").toString());
                insmap.put("postid", postinfo.get("postid").toString());
                insmap.put("drkey", "mktid");
                insmap.put("dataid", thisdep.get("deptid").toString());
                insmap.put("datacode", thisdep.get("deptcode").toString());
                insmap.put("isall", "Y");
                listinsert.add(insmap);
            }
            db.getSqlSessionTemplate().insert("insert_postdatarangedata", listinsert);
        } else {
            db.getSqlSessionTemplate().insert("insert_postdatarangedata_frommkt", postinfo);
        }
    }

    private void insdatarangebymfid(FMybatisTemplate db, List<Map<String, Object>> alldep, Map<String, Object> postinfo) throws Exception {
        ArrayList listinsert = new ArrayList();
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("entid", postinfo.get("entid"));
        para.put("postid", postinfo.get("postid"));
        para.put("drkey", "mfid");
        db.getSqlSessionTemplate().delete("del_postdatarangedata", para);
        String murange = (String)postinfo.get("murange");
        if (murange.equalsIgnoreCase("1")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("postid", postinfo.get("postid").toString());
            map.put("mfrange", "2");
            List lst1 = db.getSqlSessionTemplate().selectList("select_rangbymuid", map);
            if (lst1 != null && !lst1.equals("") && lst1.size() > 0) {
                HashMap<String, String> insmap1;
                for (int j = 0; j < lst1.size(); ++j) {
                    map.put("muid", (String)((Map)lst1.get(j)).get("muid"));
                    List lst2 = db.getSqlSessionTemplate().selectList("select_rangbymfid", map);
                    for (int i = 0; i < lst2.size(); ++i) {
                        insmap1 = new HashMap<String, String>();
                        insmap1.put("entid", postinfo.get("entid").toString());
                        insmap1.put("postid", postinfo.get("postid").toString());
                        insmap1.put("drkey", "mfid");
                        insmap1.put("dataid", ((Map)lst2.get(i)).get("mmfid").toString());
                        insmap1.put("datacode", ((Map)lst2.get(i)).get("mmfcode").toString());
                        listinsert.add(insmap1);
                    }
                }
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("postid", postinfo.get("postid").toString());
                map3.put("mfrange", "1");
                List lst3 = db.getSqlSessionTemplate().selectList("select_rangbymuid", map3);
                for (int j = 0; j < lst3.size(); ++j) {
                    insmap1 = new HashMap();
                    insmap1.put("entid", postinfo.get("entid").toString());
                    insmap1.put("postid", postinfo.get("postid").toString());
                    insmap1.put("drkey", "mfid");
                    insmap1.put("dataid", ((Map)lst3.get(j)).get("muid").toString());
                    insmap1.put("datacode", ((Map)lst3.get(j)).get("muid").toString());
                    listinsert.add(insmap1);
                }
            } else {
                HashMap<String, String> insmap1 = new HashMap<String, String>();
                insmap1.put("entid", postinfo.get("entid").toString());
                insmap1.put("postid", postinfo.get("postid").toString());
                insmap1.put("drkey", "mfid");
                insmap1.put("dataid", DRMODE_ALL);
                insmap1.put("datacode", DRMODE_ALL);
                listinsert.add(insmap1);
            }
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("postid", postinfo.get("postid").toString());
            List lst1 = db.getSqlSessionTemplate().selectList("select_rangbymuid", map);
            if (lst1 != null && !lst1.equals("") && lst1.size() > 0) {
                for (int j = 0; j < lst1.size(); ++j) {
                    if (((Map)lst1.get(j)).get("mfrange").equals("2")) {
                        map.put("muid", (String)((Map)lst1.get(j)).get("muid"));
                        List lst2 = db.getSqlSessionTemplate().selectList("select_rangbymfid", map);
                        for (int i = 0; i < lst2.size(); ++i) {
                            HashMap<String, String> insmap1 = new HashMap<String, String>();
                            insmap1.put("entid", postinfo.get("entid").toString());
                            insmap1.put("postid", postinfo.get("postid").toString());
                            insmap1.put("drkey", "mfid");
                            insmap1.put("dataid", ((Map)lst2.get(i)).get("mmfid").toString());
                            insmap1.put("datacode", ((Map)lst2.get(i)).get("mmfcode").toString());
                            listinsert.add(insmap1);
                        }
                        continue;
                    }
                    HashMap<String, String> insmap1 = new HashMap<String, String>();
                    insmap1.put("entid", postinfo.get("entid").toString());
                    insmap1.put("postid", postinfo.get("postid").toString());
                    insmap1.put("drkey", "mfid");
                    insmap1.put("dataid", ((Map)lst1.get(j)).get("muid").toString());
                    insmap1.put("datacode", ((Map)lst1.get(j)).get("muid").toString());
                    listinsert.add(insmap1);
                }
            }
        }
        db.getSqlSessionTemplate().insert("insert_postdatarangedata", listinsert);
    }

    private Map<String, Object> getparentinfo(List<Map<String, Object>> alldep, String thisdepid, int treelevel) {
        for (Map<String, Object> dep : alldep) {
            if (!dep.get("deptid").toString().equals(thisdepid)) continue;
            if (dep.get("treelevel").toString().equals(String.valueOf(treelevel))) {
                return dep;
            }
            return this.getparentinfo(alldep, dep.get("parentid").toString(), treelevel);
        }
        return null;
    }

    private void insdatarangebyregion(FMybatisTemplate db, List<Map<String, Object>> alldep, Map<String, Object> postinfo) throws Exception {
        postinfo.put("drkey", "region");
        db.getSqlSessionTemplate().delete("del_postdatarangedata", postinfo);
        String depid = (String)postinfo.get("deptid");
        Map<String, Object> thisdep = null;
        HashMap<String, String> region = new HashMap<String, String>();
        region.put("entid", postinfo.get("entid").toString());
        region.put("postid", postinfo.get("postid").toString());
        region.put("drkey", "region");
        for (Map<String, Object> dep : alldep) {
            if (!dep.get("deptid").toString().equals(depid)) continue;
            thisdep = dep;
            break;
        }
        if (null != thisdep && thisdep.size() > 0) {
            if (thisdep.get("treelevel").toString().equals("2") && !thisdep.get("deptcode").toString().equals("001")) {
                region.put("dataid", thisdep.get("deptid").toString());
                region.put("datacode", thisdep.get("deptcode").toString());
            } else {
                if (thisdep.get("treelevel").toString().equals("1") || thisdep.get("deptcode").toString().equals("001")) {
                    region.put("dataid", DRMODE_ALL);
                    region.put("datacode", DRMODE_ALL);
                    db.getSqlSessionTemplate().insert("insert_postdatarangedata_region", region);
                    return;
                }
                Map<String, Object> pdep = this.getparentinfo(alldep, depid, 2);
                region.put("dataid", pdep.get("deptid").toString());
                region.put("datacode", pdep.get("deptcode").toString());
            }
        }
        db.getSqlSessionTemplate().insert("insert_postdatarangedata", region);
    }

    private void insdatarangebycat(FMybatisTemplate db, Map<String, Object> postinfo) throws Exception {
        String catrange = (String)postinfo.get("catrange");
        postinfo.put("drkey", "cat");
        db.getSqlSessionTemplate().delete("del_postdatarangedata", postinfo);
        if (catrange.equals("1")) {
            ArrayList listins = new ArrayList();
            HashMap<String, String> cat = new HashMap<String, String>();
            cat.put("entid", postinfo.get("entid").toString());
            cat.put("postid", postinfo.get("postid").toString());
            cat.put("drkey", "cat");
            cat.put("dataid", DRMODE_ALL);
            cat.put("datacode", DRMODE_ALL);
            listins.add(cat);
            db.getSqlSessionTemplate().insert("insert_postdatarangedata", listins);
        } else {
            List listcat = db.getSqlSessionTemplate().selectList("select_PostsRES_FW", postinfo);
            ArrayList listins = new ArrayList();
            for (Map c : listcat) {
                HashMap<String, String> cat = new HashMap<String, String>();
                cat.put("entid", postinfo.get("entid").toString());
                cat.put("postid", postinfo.get("postid").toString());
                cat.put("drkey", "cat");
                cat.put("dataid", c.get("mid").toString());
                cat.put("datacode", c.get("mmfcode").toString());
                listins.add(cat);
            }
            db.getSqlSessionTemplate().insert("insert_postdatarangedata", listins);
        }
    }

    private List<Map<String, Object>> filterAllData(List<Map<String, Object>> allData, String keyCol, String keyData) {
        if (allData == null) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < allData.size(); ++i) {
            if (!MapUtils.getString(allData.get(i), keyCol, "N/A").equalsIgnoreCase(keyData)) continue;
            result.add(allData.get(i));
        }
        return result;
    }

    @Override
    public void refreshDataRange(FMybatisTemplate db, long entid, String postid) throws Exception {
        this.refreshDataRange(db, entid, postid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshDataRange(FMybatisTemplate db, long entid, String postid, List<Map<String, Object>> postData) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("entid", String.valueOf(entid));
        map.put("postid", postid);
        map.put("keycode", "%");
        List list_allData = postData;
        if (list_allData == null) {
            list_allData = db.getSqlSessionTemplate().selectList("select_postdatarangedata", map);
        }
        List<Map<String, Object>> listkey = DataRangeServiceImpl.getInstance().getDataRangeKey(db);
        for (Map<String, Object> key : listkey) {
            key.put("entid", entid);
            key.put("postid", postid);
            key.put("isallsub", "N");
            String keycol = MapUtils.getString(key, "keycol");
            List<Map<String, Object>> listdata = this.filterAllData(list_allData, "drkey", MapUtils.getString(key, "keycode"));
            if (listdata.size() == 0) {
                key.put("dataid", DRMODE_NON);
                continue;
            }
            if (listdata.get(0).get("dataid").toString().equalsIgnoreCase(DRMODE_ALL)) {
                key.put("dataid", DRMODE_ALL);
                continue;
            }
            if (listdata.get(0).get("isall").toString().equalsIgnoreCase("Y")) {
                key.put("dataid", listdata.get(0).get("dataid").toString());
                key.put("isallsub", "Y");
                continue;
            }
            if (listdata.size() > this.MAX_DATARANGE_NUM) {
                key.put("dataid", DRMODE_IN);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            for (int i = 0; i < listdata.size(); ++i) {
                sb.append("'" + listdata.get(i).get(keycol) + "',");
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.setLength(sb.length() - 1);
            }
            sb.append(")");
            key.put("dataid", sb.toString());
        }
        db.getSqlSessionTemplate().delete("del_DataRange", map);
        List<Map<String, Object>> listconfig = DataRangeServiceImpl.getInstance().getDataRangeConfig(db);
        ArrayList<Map<String, Object>> list_datarange = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> config : listconfig) {
            boolean iball = true;
            String wherestr = String.valueOf(config.get("wherestr"));
            for (Map<String, Object> key : listkey) {
                int s = wherestr.indexOf(key.get("sl").toString());
                int e = wherestr.indexOf(key.get("el").toString());
                if (s <= 0 && (s != 0 || !wherestr.substring(s, key.get("sl").toString().length()).equalsIgnoreCase(key.get("sl").toString())) || e <= s) continue;
                String col = wherestr.substring(s + key.get("sl").toString().length(), e);
                String replacestr = wherestr.substring(s, e + key.get("el").toString().length());
                Object subwhere = key.get("wherestr").toString();
                String dataid = key.get("dataid").toString();
                String isallsub = String.valueOf(key.get("isallsub"));
                String allsubwhere = String.valueOf(key.get("allsubwhere"));
                if (dataid.equalsIgnoreCase(DRMODE_ALL)) {
                    subwhere = DRMODE_ALLWHERE;
                } else if (dataid.equalsIgnoreCase(DRMODE_NON)) {
                    subwhere = DRMODE_NONWHERE;
                } else if (dataid.equalsIgnoreCase(DRMODE_IN)) {
                    if (!StringUtils.isEmpty((Object)subwhere)) {
                        subwhere = col + ((String)subwhere).replace("#{postid}", "'" + postid + "'").replace("#{entid}", "'" + entid + "'");
                        iball = false;
                    } else {
                        subwhere = DRMODE_ALLWHERE;
                    }
                } else if (isallsub.equalsIgnoreCase("Y")) {
                    iball = false;
                    subwhere = !StringUtils.isEmpty((Object)allsubwhere) ? col + allsubwhere.replace("#{postid}", "'" + postid + "'").replace("#{entid}", "'" + entid + "'").replace("#{dataid}", "'" + dataid + "'") : DRMODE_ALLWHERE;
                } else {
                    iball = false;
                    subwhere = col + " in " + dataid;
                }
                String subwherekey_s = "<" + key.get("keycode") + "where>";
                String subwherekey_e = "</" + key.get("keycode") + "where>";
                int ws = wherestr.indexOf(subwherekey_s);
                int we = wherestr.indexOf(subwherekey_e);
                if ((ws > 0 || ws == 0 && wherestr.substring(ws, subwherekey_s.length()).equalsIgnoreCase(subwherekey_s)) && we > ws) {
                    if (((String)subwhere).equalsIgnoreCase(DRMODE_ALLWHERE)) {
                        replacestr = wherestr.substring(ws, we + subwherekey_e.length());
                    } else {
                        wherestr = wherestr.replace(subwherekey_s, "").replace(subwherekey_e, "");
                    }
                }
                wherestr = wherestr.replace(replacestr, (CharSequence)subwhere);
            }
            if (iball) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tablename", MapUtils.getString(config, "tablename"));
            data.put("wherestr", wherestr);
            data.put("postid", postid);
            data.put("entid", String.valueOf(entid));
            data.put("ph_time", new Date());
            list_datarange.add(data);
        }
        if (list_datarange != null && list_datarange.size() > 0) {
            this.batchIns.batchInsert(db, list_datarange, "datarange", 1000);
            String key = this.genDataRangeKey(entid, postid);
            try {
                ArrayList<DataRange> range = new ArrayList<DataRange>();
                for (int i = 0; i < list_datarange.size(); ++i) {
                    DataRange dr = new DataRange();
                    dr.setTablename(MapUtils.getString((Map)list_datarange.get(i), "tablename"));
                    dr.setWherestr(MapUtils.getString((Map)list_datarange.get(i), "wherestr"));
                    range.add(dr);
                }
                CacheUtils.getCacheUtils().putData(key, range, 86400);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String genDataRangeKey(long ent_id, String postid) {
        return DATARANGE_KEY.concat(String.valueOf(ent_id)).concat(":").concat(postid);
    }

    @Override
    public List<DataRange> getDataRange(long ent_id, String postid) {
        List<DataRange> range = null;
        String key = this.genDataRangeKey(ent_id, postid);
        range = (List<DataRange>)CacheUtils.getCacheUtils().getData(key);
        if (null == range || range.size() <= 0) {
            range = this.RefreshCached(ent_id, postid, null);
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataRange> RefreshCached(long ent_id, String postid, FMybatisTemplate db) {
        List range = null;
        String key = this.genDataRangeKey(ent_id, postid);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("postid", postid);
        map.put("entid", String.valueOf(ent_id));
        try {
            range = db.getSqlSessionTemplate().selectList("select_DataRange", map);
            CacheUtils.getCacheUtils().putData(key, range, 86400);
        }
        catch (Exception e) {
            List<DataRange> list = null;
            return list;
        }
        return range;
    }

    public int getMAX_DATARANGE_NUM() {
        return this.MAX_DATARANGE_NUM;
    }

    public void setMAX_DATARANGE_NUM(int mAX_DATARANGE_NUM) {
        this.MAX_DATARANGE_NUM = mAX_DATARANGE_NUM;
    }

    @Override
    public void createDataRange(long entid, String postid, String rangeType, List<Object> range) throws Exception {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("drkey", rangeType);
        para.put("entid", entid);
        para.put("postid", postid);
        FMybatisTemplate fso = OcpApplicationContext.getInstance().getBean("GlobalStorageOperation", FMybatisTemplate.class);
        fso.getSqlSessionTemplate().delete("del_postdatarangedata", para);
        ArrayList<Map<String, Object>> postdatarange = new ArrayList<Map<String, Object>>();
        Date now = new Date();
        for (Object obj : range) {
            Map insmap = (Map)obj;
            insmap.put("entid", entid);
            insmap.put("postid", postid);
            insmap.put("drkey", rangeType);
            insmap.put("ph_time", now);
            insmap.put("isall", "N");
            postdatarange.add(insmap);
        }
        BatchInsService batchIns = new BatchInsService();
        batchIns.batchInsert(fso, postdatarange, "postdatarangedata", 2000);
    }

    @AutoCache(Service="OCP", KeyArgIndex=100, TimeOut=86400)
    public List<Map<String, Object>> getDataRangeKey(FMybatisTemplate db) {
        return db.getSqlSessionTemplate().selectList("select_DataRangeKey", null);
    }

    @AutoCache(Service="OCP", KeyArgIndex=100, TimeOut=86400)
    public List<Map<String, Object>> getDataRangeConfig(FMybatisTemplate db) {
        return db.getSqlSessionTemplate().selectList("select_DataRangeConfig", null);
    }

    @Override
    @AutoCache(Service="OCP", KeyArgIndex=100, TimeOut=86400)
    public JSONObject getDataRangeTree(ServiceSession session) throws Exception {
        String METHOD_TREE = "efuture.dataRangPermission.tree";
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest((Object)session, "efuture.dataRangPermission.tree", (Object)DataUtils.newJSONObject("drpid", -1).toJSONString(), "portal");
        if ("0".equalsIgnoreCase(resp.getReturncode())) {
            JSONObject data = (JSONObject)resp.getData();
            return data;
        }
        return null;
    }

    @Override
    public void clearAutoCache() {
        CacheUtils.getCacheUtils().deleteBatch("OCP:DataRangeServiceImpl");
    }
}

