/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.cache.redis.ObjectBytesExchange;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class CacheUtilsRedisSentinel
extends CacheUtilsRediscached
implements Serializable {
    private JedisSentinelPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    private boolean debug = false;
    public Logger logger = Logger.getLogger(CacheUtilsRedisSentinel.class);

    public CacheUtilsRedisSentinel() {
        this(null);
    }

    public CacheUtilsRedisSentinel(String config) {
        this(config, -1);
    }

    public CacheUtilsRedisSentinel(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    @Override
    public Object getCacheType() {
        return "sentinel";
    }

    private Jedis getJedis() {
        try {
            return this.jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void returnJedis(Jedis jedis) {
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String putDataByElapsed(String key, Object object, int timeout, List<String> elapsed) {
        return this.putData(key, object, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putData(String key, Object object, int timeout) {
        long starttime = System.currentTimeMillis();
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (this.debug) {
                ServiceLogs.debuglog("info", "RedisSentinel.putData-createPool", starttime);
                starttime = System.currentTimeMillis();
            }
        }
        Jedis jedis = this.getJedis();
        if (this.debug) {
            ServiceLogs.debuglog("info", "RedisSentinel.putData-getPool", starttime);
            starttime = System.currentTimeMillis();
        }
        try {
            if (timeout < 0) {
                int n = timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            if (timeout > 0) {
                jedis.setex(this.getKey(key).getBytes(), timeout, SerializeUtil.serialize(object));
            } else {
                jedis.set(this.getKey(key).getBytes(), SerializeUtil.serialize(object));
            }
            String string = key;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (this.debug) {
                ServiceLogs.debuglog("info", "RedisSentinel.putData-setEx", starttime);
                starttime = System.currentTimeMillis();
            }
            this.returnJedis(jedis);
            if (this.debug) {
                ServiceLogs.debuglog("info", "RedisSentinel.putData-returnPool", starttime);
                starttime = System.currentTimeMillis();
            }
        }
    }

    @Override
    public Object getDataByElapsed(String key, List<String> elapsed) {
        return this.getData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        long starttime = System.currentTimeMillis();
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (this.debug) {
                ServiceLogs.debuglog("info", "RedisSentinel.getData-createPool", starttime);
                starttime = System.currentTimeMillis();
            }
        }
        Jedis jedis = this.getJedis();
        if (this.debug) {
            ServiceLogs.debuglog("info", "RedisSentinel.getData-getPool", starttime);
            starttime = System.currentTimeMillis();
        }
        Object result = null;
        try {
            byte[] obj = jedis.get(this.getKey(key).getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.debug) {
                ServiceLogs.debuglog("info", "RedisSentinel.getData-getData", starttime);
                starttime = System.currentTimeMillis();
            }
            this.returnJedis(jedis);
            if (this.debug) {
                ServiceLogs.debuglog("info", "RedisSentinel.getData-returnPool", starttime);
                starttime = System.currentTimeMillis();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        Jedis jedis = this.getJedis();
        try {
            jedis.del(this.getKey(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    private synchronized JedisSentinelPool CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            String[] str_nodes;
            this.logger.info((Object)"Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            HashSet<String> sentinels = new HashSet<String>();
            for (String str : str_nodes = this.config.getRedisNodes().split(",")) {
                sentinels.add(str);
            }
            this.jedispool = new JedisSentinelPool(this.config.getRedisMaster(), sentinels, (GenericObjectPoolConfig)poolConfig, this.config.getRedisTimeout(), this.config.getRedisPassword(), this.config.getRedisDatabase());
        } else {
            Object ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini";
                ini0 = p + "/conf/redisCluster.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File((String)ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redisCluster.ini path:" + (String)ini));
            if (input.exists()) {
                String[] str_nodes;
                String password_prop;
                String password;
                String smaxWait;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                FileInputStream is = new FileInputStream(input);
                Properties p = new Properties();
                p.load(is);
                ((InputStream)is).close();
                String sNodes = Utils.getEnvValue(p.getProperty("redis.nodes"));
                if (sNodes != null) {
                    nodes = sNodes.trim();
                }
                if ((smaxActive = p.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((smaxWait = p.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                String master = Utils.getEnvValue(p.getProperty("redis.master"));
                String sdatabase = Utils.getEnvValue(p.getProperty("redis.database"));
                if (sdatabase != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("redisSentinel server:" + sNodes));
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                HashSet<String> sentinels = new HashSet<String>();
                for (String str : str_nodes = nodes.split(",")) {
                    sentinels.add(str);
                }
                this.jedispool = new JedisSentinelPool(master, sentinels, (GenericObjectPoolConfig)config, timeout, password, database);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                throw new FileNotFoundException();
            }
        }
        return this.jedispool;
    }

    @Override
    public double incrByFloat(String key, double integer) {
        if (key == null) {
            return 0.0;
        }
        return this.getJedis().incrByFloat(key, integer);
    }

    @Override
    public String get(String key) {
        return this.getJedis().get(key);
    }

    @Override
    public boolean lock(String key, int seconds) {
        return this.getJedis().setnx(this.encode(key), String.valueOf(System.currentTimeMillis() + (long)(seconds * 1000))) == 1L;
    }

    @Override
    public long delObject(String key) {
        return this.getJedis().del(key);
    }

    @Override
    public String setObject(String key, int seconds, Object obj) {
        Jedis jedis = this.getJedis();
        String ret = "";
        if (key == null || obj == null) {
            return null;
        }
        byte[] byteObj = ObjectBytesExchange.toByteArray(obj);
        if (null == byteObj) {
            return null;
        }
        ret = seconds <= 0 ? jedis.set(key.getBytes(), byteObj) : jedis.setex(key.getBytes(), seconds, byteObj);
        return ret;
    }

    @Override
    public long rpush(String key, String value) {
        return this.getJedis().rpush(key, new String[]{value});
    }

    @Override
    public long lpush(String key, String ... value) {
        if (key == null) {
            return 0L;
        }
        return this.getJedis().lpush(key, value);
    }

    @Override
    public long rpush(String key, String ... value) {
        if (key == null) {
            return 0L;
        }
        return this.getJedis().rpush(key, value);
    }

    @Override
    public long llen(String key) {
        if (key == null) {
            return 0L;
        }
        return this.getJedis().llen(key);
    }

    @Override
    public String rpop(String key) {
        if (key == null) {
            return null;
        }
        return this.getJedis().rpop(key);
    }

    @Override
    public byte[] getBytes(byte[] key) {
        if (key == null) {
            return null;
        }
        return this.getJedis().get(key);
    }

    @Override
    public Object getObject(String key) {
        if (key == null) {
            return null;
        }
        byte[] ret = this.getBytes(key.getBytes());
        if (ret == null) {
            return null;
        }
        return ObjectBytesExchange.toObject(ret);
    }
}

