/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.user;

import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserService;
import com.efuture.ocp.user.UserTokenInfo;
import java.util.List;
import org.springframework.util.StringUtils;

public class UserDataRangeSrv {
    private static final ThreadLocal<UserTokenInfo> LOCAL_USERINFO = new ThreadLocal();
    private static final ThreadLocal<List<DataRange>> LOCAL_DataRange = new ThreadLocal();
    private static final ThreadLocal<String> LOCAL_TOKEN = new ThreadLocal();
    private static final ThreadLocal<Boolean> LOCAL_ISRANGE = new ThreadLocal();
    private static final ThreadLocal<Boolean> RangeIsExec = new ThreadLocal();
    private static boolean OPENRANGE;
    private static String PORTALKEY;
    private static UserService us;
    private static final String TOKEN_MEMKEY = "OCP:TOKEN:";

    public static void setlocaltoken(String token) {
        LOCAL_TOKEN.set(token);
        LOCAL_DataRange.remove();
        LOCAL_USERINFO.remove();
        RangeIsExec.set(false);
        if (StringUtils.isEmpty((Object)token)) {
            LOCAL_ISRANGE.set(false);
        } else {
            LOCAL_ISRANGE.set(true);
        }
    }

    public static boolean getlocalisrange() {
        if (!OPENRANGE) {
            return OPENRANGE;
        }
        Boolean b = LOCAL_ISRANGE.get();
        if (null == b) {
            return false;
        }
        return b;
    }

    public static boolean getRangeisexec() {
        Boolean b = RangeIsExec.get();
        if (null == b) {
            return false;
        }
        return b;
    }

    public static void setRangeisexec(boolean exec) {
        RangeIsExec.set(exec);
    }

    public static void setlocalisrange(boolean isrange) {
        LOCAL_ISRANGE.set(isrange);
    }

    public static String getlocaltoken() {
        return LOCAL_TOKEN.get();
    }

    public static UserTokenInfo getlocaluser() {
        if (!OPENRANGE) {
            return null;
        }
        return UserDataRangeSrv.getuserinfo();
    }

    public static UserTokenInfo getuserinfo() {
        UserTokenInfo info = LOCAL_USERINFO.get();
        if (null == info) {
            String token = UserDataRangeSrv.getlocaltoken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            info = UserDataRangeSrv.getuserinfo(token);
            LOCAL_USERINFO.set(info);
        }
        return LOCAL_USERINFO.get();
    }

    public static List<DataRange> getlocaldatarange() {
        if (!OPENRANGE) {
            return null;
        }
        List<DataRange> dr = LOCAL_DataRange.get();
        if (null == dr || dr.size() < 1) {
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();
            if (null == info) {
                return null;
            }
            dr = UserDataRangeSrv.getDataRangeBytoken(info.getToken());
            LOCAL_DataRange.set(dr);
        }
        return dr;
    }

    public static UserTokenInfo getuserinfo(String token) {
        if (!OPENRANGE) {
            return null;
        }
        if (StringUtils.isEmpty((Object)token)) {
            return null;
        }
        String key = TOKEN_MEMKEY + token;
        UserTokenInfo info = null;
        if (!PORTALKEY.equalsIgnoreCase("cloud")) {
            info = (UserTokenInfo)CacheUtils.getCacheUtils().getData(key);
        }
        if (null == info) {
            UserService us = UserDataRangeSrv.getServerSrv();
            info = us.getuserinfo(token);
            if (null == info) {
                return null;
            }
            if (!PORTALKEY.equalsIgnoreCase("cloud")) {
                CacheUtils.getCacheUtils().putData(key, info, 86400);
            }
        }
        return info;
    }

    private static UserService getServerSrv() {
        if (null == us) {
            String userService = "UserServerSrv_" + PORTALKEY;
            System.out.println("portalkey:".concat(PORTALKEY));
            System.out.println("userService:".concat(userService));
            us = SpringBeanFactory.containsBean(userService) ? SpringBeanFactory.getBean(userService, UserService.class) : SpringBeanFactory.getBean("UserServerSrv", UserService.class);
        }
        return us;
    }

    public static List<DataRange> getDataRangeBytoken(String token) {
        if (!OPENRANGE) {
            return null;
        }
        UserTokenInfo info = UserDataRangeSrv.getuserinfo(token);
        if (null == info) {
            return null;
        }
        return info.getDatarange();
    }

    public static boolean isOpenrange() {
        return OPENRANGE;
    }

    public static void setOpenrange(boolean openrange) {
        OPENRANGE = openrange;
    }

    public static String getPortalkey() {
        return PORTALKEY;
    }

    public static void setPortalkey(String portalkey2) {
        PORTALKEY = portalkey2;
    }

    private static interface PortalKey {
        public static final String CLOUD = "cloud";
        public static final String CONGOU = "congou";
    }
}

