/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.boot;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.IJobHandler;

public abstract class IJobHandlerBase
extends IJobHandler {
    public abstract String jobDescribe(String var1);

    public abstract String jobParamExample();

    public abstract String jobCronSuggestion();

    public abstract ReturnT<String> onExecute(String var1) throws Exception;

    protected void onInit() {
        XxlJobHelper.log("\u3010{}\u3011JobHandler \u521d\u59cb\u5316.", this.jobDescribe(null));
    }

    protected void onDestroy() {
        XxlJobHelper.log("\u3010{}\u3011JobHandler \u5df2\u9500\u6bc1.", this.jobDescribe(null));
    }

    protected void executeBeforeDone(String param) {
        XxlJobHelper.log("\u3010{}\u3011JobHandler \u5efa\u8bae\u8c03\u5ea6\u5468\u671f: {}", this.jobDescribe(param), this.jobCronSuggestion());
        XxlJobHelper.log("\u3010{}\u3011JobHandler \u51c6\u5907\u5f00\u59cb\u6267\u884c: {}", this.jobDescribe(param), param);
    }

    protected void executeAfterDone(String param) {
        XxlJobHelper.log("\u3010{}\u3011JobHandler \u6267\u884c\u7ed3\u675f.", this.jobDescribe(param));
    }

    protected void executeException(String param, Exception ex) {
        XxlJobHelper.log("\u3010{}\u3011JobHandler \u6267\u884c\u5f02\u5e38: {}", this.jobDescribe(param), ex.getMessage());
    }

    @Override
    public void execute() throws Exception {
        String param = XxlJobHelper.getJobParam();
        this.executeBeforeDone(param);
        ReturnT<String> resp = null;
        try {
            resp = this.onExecute(param);
            this.executeAfterDone(param);
        }
        catch (Exception ex) {
            this.executeException(param, ex);
            throw ex;
        }
        String responseMsg = resp.toString();
        XxlJobHelper.log(responseMsg, new Object[0]);
        if (resp.getCode() == 200) {
            XxlJobHelper.handleSuccess();
        } else {
            XxlJobHelper.handleFail(resp.getMsg());
        }
    }

    @Override
    public void init() {
        this.onInit();
    }

    @Override
    public void destroy() {
        this.onDestroy();
    }
}

