/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.executor.impl;

import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.glue.GlueFactory;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class XxlJobSpringExecutor
extends XxlJobExecutor
implements ApplicationContextAware,
SmartInitializingSingleton,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobSpringExecutor.class);
    private static ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        this.initJobHandlerRepository(applicationContext);
        this.initJobHandlerMethodRepository(applicationContext);
        GlueFactory.refreshInstance(1);
        try {
            super.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private void initJobHandlerRepository(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(JobHandler.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (!(serviceBean instanceof IJobHandler)) continue;
                String name = serviceBean.getClass().getAnnotation(JobHandler.class).value();
                IJobHandler handler = (IJobHandler)serviceBean;
                if (XxlJobSpringExecutor.loadJobHandler(name) != null) {
                    throw new RuntimeException("xxl-job jobhandler[" + name + "] naming conflicts.");
                }
                XxlJobSpringExecutor.registJobHandler(name, handler);
            }
        }
    }

    private void initJobHandlerMethodRepository(ApplicationContext applicationContext) {
        String[] beanDefinitionNames;
        if (applicationContext == null) {
            return;
        }
        for (String beanDefinitionName : beanDefinitionNames = applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = null;
            Lazy onBean = (Lazy)applicationContext.findAnnotationOnBean(beanDefinitionName, Lazy.class);
            if (onBean != null) {
                logger.debug("xxl-job annotation scan, skip @Lazy Bean:{}", (Object)beanDefinitionName);
                continue;
            }
            bean = applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<XxlJob>(){

                    public XxlJob inspect(Method method) {
                        return (XxlJob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlJob.class);
                    }
                });
            }
            catch (Throwable ex) {
                logger.error("xxl-job method-jobhandler resolve error for bean[" + beanDefinitionName + "].", ex);
            }
            if (annotatedMethods == null || annotatedMethods.isEmpty()) continue;
            for (Map.Entry methodXxlJobEntry : annotatedMethods.entrySet()) {
                Method executeMethod = (Method)methodXxlJobEntry.getKey();
                XxlJob xxlJob = (XxlJob)methodXxlJobEntry.getValue();
                this.registJobHandler(xxlJob, bean, executeMethod);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        XxlJobSpringExecutor.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

