/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.rocketmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.consumer.ConsumerNode;
import com.efuture.ocp.taskcore.consumer.IConsumerDupHandle;
import com.efuture.ocp.taskcore.consumer.IConsumerHandle;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.message.MessageStatus;
import com.efuture.ocp.taskcore.rocketmq.RocketMqMessageHandle;
import com.efuture.ocp.taskcore.service.IMessageDupHandle;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.util.StringUtils;

public class DefaultFutRocketMqConsumerListener
implements RocketMQListener<MessageExt> {
    private IMessageDupHandle messagedup;
    private IMessageHandle messagehandle;
    private ConsumerNode nodeconfig;
    private IConsumerHandle consumerHandler;
    private String consumerobj;
    private String consumerGroup;
    private static Logger logger = Logger.getLogger(DefaultFutRocketMqConsumerListener.class);

    public IMessageDupHandle getMessagedup() {
        if (this.messagedup == null) {
            this.messagedup = (IMessageDupHandle)SpringBeanFactory.getBean((String)"MessageDupService", IMessageDupHandle.class);
        }
        return this.messagedup;
    }

    public void setConsumerHandler(IConsumerHandle consumerHandler) {
        this.consumerHandler = consumerHandler;
    }

    public DefaultFutRocketMqConsumerListener() {
        this.setConsumerGroupbyCalss();
    }

    public void setConsumerGroupbyCalss() {
        Class<?> cls = this.getClass();
        if (cls.isAnnotationPresent(RocketMQMessageListener.class)) {
            RocketMQMessageListener s = cls.getAnnotation(RocketMQMessageListener.class);
            this.setConsumerGroup(s.consumerGroup());
        }
    }

    public void onMessage(MessageExt msgExt) {
        JSONObject jobj = (JSONObject)JSONObject.parse((byte[])msgExt.getBody(), (Feature[])new Feature[0]);
        Message msg = (Message)JSONObject.toJavaObject((JSON)jobj, Message.class);
        msg.setExecdate(new Date());
        msg.setExecnode(this.getConsumerGroup());
        long stime = System.currentTimeMillis();
        ServiceLogs.logConsumeMqStart((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)msgExt.getMsgId());
        if (this.getMessagedup() != null && this.getMessagedup().checkMessageDup(msg) < 1) {
            msg.setStatus(MessageStatus.DUP.name());
            msg.setMsg("\u6d88\u606f\u91cd\u590d,\u4e0d\u6267\u884c");
            IConsumerHandle ch = this.getConsumerHandler();
            if (ch instanceof IConsumerDupHandle) {
                ((IConsumerDupHandle)ch).isDup(this.nodeconfig, msg);
            }
            ServiceLogs.logConsumeMqSuccess((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)msg.getStatus(), (long)stime);
            this.consumeCallbackMessage(msg);
            return;
        }
        try {
            this.doConsumer(msg);
            if (!msg.getStatus().equalsIgnoreCase(MessageStatus.NORUN.name())) {
                msg.setStatus(MessageStatus.SUCCESS.name());
            }
            ServiceLogs.logConsumeMqSuccess((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)msg.getStatus(), (long)stime);
        }
        catch (Exception e) {
            if (this.messagedup != null) {
                this.getMessagedup().delMessageDup(msg);
            }
            logger.error((Object)"", (Throwable)e);
            msg.setStatus(MessageStatus.FAIL.name());
            String msgstr = e.getMessage();
            if (!StringUtils.isEmpty((Object)msgstr)) {
                if (msgstr.length() > 1900) {
                    msgstr = msgstr.substring(0, 1900);
                }
                msg.setMsg(msgstr);
            } else {
                msg.setMsg("Unknown Exception");
            }
            ServiceLogs.logConsumeMqError((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)msg.getStatus(), (String)msg.getMsg(), (long)stime);
            throw new ServiceException("7000", e.getMessage(), new Object[0]);
        }
        finally {
            this.consumeCallbackMessage(msg);
        }
    }

    public IConsumerHandle getConsumerHandler() {
        if (this.consumerHandler == null) {
            this.consumerHandler = (IConsumerHandle)SpringBeanFactory.getBean((String)this.consumerobj, IConsumerHandle.class);
        }
        return this.consumerHandler;
    }

    public IMessageHandle getMessagehandle() {
        if (this.messagehandle == null) {
            this.messagehandle = new RocketMqMessageHandle();
        }
        return this.messagehandle;
    }

    private void doConsumer(Message msg) throws Exception {
        if (this.nodeconfig == null) {
            this.nodeconfig = new ConsumerNode();
        }
        this.getConsumerHandler().consume(this.nodeconfig, msg);
    }

    private void consumeCallbackMessage(Message msg) {
        this.getMessagehandle().consumeCallbackMessage(this.nodeconfig, msg);
    }

    public String getConsumerobj() {
        return this.consumerobj;
    }

    public void setConsumerobj(String consumerobj) {
        this.consumerobj = consumerobj;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }
}

