/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.rocketmq;

import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.rocketmq.RocketMqMessageHandle;
import com.efuture.ocp.taskcore.service.IMessageDupHandle;
import com.efuture.ocp.taskcore.service.MessageDupService;
import org.apache.rocketmq.common.UtilAll;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqAutoConfig {
    @Bean(name={"MessageHandle"})
    @ConditionalOnProperty(prefix="rocketmq", value={"nameServer", "producer.group"})
    @ConditionalOnExpression(value="!'${rocketmq.name-server}'.equals('none') && !'${rocketmq.name-server}'.equals('')")
    public IMessageHandle MessageHandle() {
        return new RocketMqMessageHandle();
    }

    @Bean(name={"MessageDupService"})
    @ConditionalOnProperty(prefix="rocketmq", value={"nameServer", "producer.group"})
    @ConditionalOnExpression(value="!'${rocketmq.name-server}'.equals('none') && !'${rocketmq.name-server}'.equals('')")
    @ConditionalOnMissingBean(name={"MessageDupService"})
    public IMessageDupHandle MessageDupHandle() {
        return new MessageDupService();
    }

    static {
        System.setProperty("rocketmq.client.name", String.valueOf(UtilAll.getPid()) + "@" + System.currentTimeMillis());
    }
}

