/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.autorollback;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.autorollback.RollBackOperationData;
import com.efuture.ocp.common.autorollback.RollbackHandle;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.taskcore.autorollback.CustomAutoRollback;
import com.efuture.ocp.taskcore.service.TaskProducer;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class DbmsgAutoRollbackHandle
implements RollbackHandle {
    public static Logger logger = Logger.getLogger(DbmsgAutoRollbackHandle.class);

    public void dorollback(List<RollBackOperationData> oplist) {
        for (RollBackOperationData data : oplist) {
            this.sendRollbackMsg(data);
        }
    }

    public RollBackOperationData getMsgData(RollBackOperationData data) {
        String getmsgbean = data.getUrlkey() + ".rollback";
        data.setEvent(data.getUrlkey());
        data.setTopic("standardrollback");
        JSONObject rollback = (JSONObject)JSONObject.parse((String)data.getParam());
        rollback.put("ent_id", (Object)data.getSession().getEnt_id());
        rollback.put("urlkey", (Object)data.getUrlkey());
        data.setMsgkey(data.getUrlkey().concat("-").concat(String.valueOf(UniqueID.getUniqueIDArray((int)10).get(4))));
        data.setRollbackparam(rollback.toJSONString());
        if (!SpringBeanFactory.containsBean((String)getmsgbean)) {
            logger.error((Object)("AutoRollback-->\u6ca1\u6709\u5b9a\u4e49\uff1a" + getmsgbean));
            return data;
        }
        CustomAutoRollback getmsg = (CustomAutoRollback)SpringBeanFactory.getBean((String)getmsgbean, CustomAutoRollback.class);
        if (!getmsg.ibCanUse()) {
            return data;
        }
        return getmsg.getMsgData(data);
    }

    public void sendRollbackMsg(RollBackOperationData data) {
        if (StringUtils.isEmpty((Object)data)) {
            return;
        }
        RollBackOperationData msgdata = null;
        try {
            msgdata = this.getMsgData(data);
        }
        catch (Exception ex) {
            logger.error((Object)"AutoRollback-->\u83b7\u53d6\u51b2\u6b63\u4fe1\u606f\u5931\u8d25:".concat(ex.getMessage()));
            return;
        }
        String keyvalue = msgdata.getMsgkey();
        if (StringUtils.isEmpty((Object)keyvalue)) {
            logger.error((Object)"AutoRollback-->".concat(data.getUrlkey()).concat("\u6ca1\u6709keyvalue"));
            return;
        }
        String event = msgdata.getEvent();
        String topic = msgdata.getTopic();
        String param = msgdata.getRollbackparam();
        logger.info((Object)"TaskProducer->DbmsgAutoRollbackHandle:".concat(keyvalue));
        try {
            TaskProducer.produce(data.getSession().getEnt_id(), topic, event, keyvalue, param);
        }
        catch (Exception ex) {
            logger.error((Object)"TaskProducer->DbmsgAutoRollbackHandle:".concat(ex.getMessage()));
        }
    }
}

