/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.transmanager;

import com.efuture.ocp.taskcore.transmanager.EventTransService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.util.StringUtils;

public class EventDataSourceTransactionManager
extends DataSourceTransactionManager {
    private ThreadLocal<List<Object>> trans_ignore = new ThreadLocal();
    @Value(value="${eventdstsm.ignorekeys:}")
    private List<String> ignoreKeys = null;

    public List<String> getIgnoreKeys() {
        return this.ignoreKeys;
    }

    public void setIgnoreKeys(List<String> ignoreKeys) {
        if (ignoreKeys != null) {
            this.ignoreKeys = new ArrayList<String>();
            for (String key : ignoreKeys) {
                String[] ss;
                for (String s : ss = key.split(",")) {
                    this.ignoreKeys.add(s);
                }
            }
        } else {
            this.ignoreKeys = ignoreKeys;
        }
    }

    private boolean isIgnore(String methodName) {
        if (StringUtils.isEmpty((Object)methodName)) {
            return false;
        }
        for (String key : this.ignoreKeys) {
            if (!methodName.contains(key)) continue;
            return true;
        }
        return false;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        super.doBegin(transaction, definition);
        String name = definition.getName();
        if (this.isIgnore(name)) {
            List<Object> ignore_objs = this.trans_ignore.get();
            if (ignore_objs == null) {
                ignore_objs = new ArrayList<Object>();
            }
            ignore_objs.add(transaction);
            this.trans_ignore.set(ignore_objs);
            this.logger.debug((Object)("Ignore EventTransService Begin:" + transaction.toString()));
        } else {
            EventTransService.doBegin();
        }
        this.logger.debug((Object)("\u5f00\u59cb\u4e8b\u7269" + transaction.toString()));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        super.doCommit(status);
        this.logger.debug((Object)("\u63d0\u4ea4\u4e8b\u7269" + status.toString()));
        try {
            List<Object> ignore_objs = this.trans_ignore.get();
            if (ignore_objs != null && ignore_objs.contains(status.getTransaction())) {
                this.trans_ignore.get().remove(status.getTransaction());
                this.logger.debug((Object)("Ignore EventTransService Commit:" + status.toString()));
            } else {
                EventTransService.doCommit();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u63d0\u4ea4\u6d88\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        super.doRollback(status);
        this.logger.debug((Object)("\u56de\u6eda\u4e8b\u7269" + status.toString()));
        try {
            List<Object> ignore_objs = this.trans_ignore.get();
            if (ignore_objs != null && ignore_objs.contains(status.getTransaction())) {
                this.trans_ignore.get().remove(status.getTransaction());
                this.logger.debug((Object)("Ignore EventTransService Rollback:" + status.toString()));
            } else {
                EventTransService.doRollback();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u53d6\u6d88\u6d88\u606f\u9519\u8bef", (Throwable)e);
        }
    }
}

