/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.transmanager;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.service.TaskProducer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class EventTransService {
    @Autowired
    private static ApplicationContext applicationContext;
    protected static transient Logger logger;
    private static final ThreadLocal<List<Message>> MESSAGELIST;
    private static final ThreadLocal<List<ApplicationEvent>> EVENTLIST;

    public static void addEvent(ApplicationEvent event) {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        if (eventlist == null) {
            eventlist = new ArrayList<ApplicationEvent>();
        }
        eventlist.add(event);
        EVENTLIST.set(eventlist);
    }

    public static void addMsg(Message msg) {
        List<Message> msglist = MESSAGELIST.get();
        if (msglist == null) {
            msglist = new ArrayList<Message>();
        }
        msglist.add(msg);
        MESSAGELIST.set(msglist);
    }

    private static void doMessageRollback() {
        List<Message> msglist = MESSAGELIST.get();
        if (msglist != null && msglist.size() > 0) {
            logger.info("doRollback--->\u6709\u6d88\u606f{" + msglist.size() + "}\u672a\u63d0\u4ea4!");
            logger.info("************************************************************");
            logger.info(JSONObject.toJSON(msglist).toString());
            logger.info("************************************************************");
        }
        MESSAGELIST.remove();
    }

    private static void doEventRollback() {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        if (eventlist != null && eventlist.size() > 0) {
            logger.info("doRollback:eventlist--->\u6709\u6d88\u606f{" + eventlist.size() + "}\u672a\u63d0\u4ea4!");
            logger.info("************************************************************");
            logger.info(JSONObject.toJSON(eventlist).toString());
            logger.info("************************************************************");
        }
        EVENTLIST.remove();
    }

    public static void doRollback() {
        EventTransService.doMessageRollback();
        EventTransService.doEventRollback();
    }

    private static void doMessageBegin() {
        List<Message> msglist = MESSAGELIST.get();
        if (msglist != null && msglist.size() > 0) {
            logger.info("doBegin--->\u6709\u6d88\u606f{" + msglist.size() + "}\u672a\u63d0\u4ea4!");
            logger.info("************************************************************");
            logger.info(JSONObject.toJSON(msglist).toString());
            logger.info("************************************************************");
        }
        MESSAGELIST.remove();
    }

    private static void doEventBegin() {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        if (eventlist != null && eventlist.size() > 0) {
            logger.info("doBegin:eventlist--->\u6709\u6d88\u606f{" + eventlist.size() + "}\u672a\u63d0\u4ea4!");
            logger.info("************************************************************");
            logger.info(JSONObject.toJSON(eventlist).toString());
            logger.info("************************************************************");
        }
        EVENTLIST.remove();
    }

    public static void doBegin() {
        EventTransService.doMessageBegin();
        EventTransService.doEventBegin();
    }

    private static void doMessageCommit() {
        List<Message> msglist = MESSAGELIST.get();
        try {
            if (msglist != null) {
                for (Message msg : msglist) {
                    TaskProducer.asyncproduce(msg);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u6d88\u606f\u9519\u8bef!", (Throwable)e);
            logger.error("************************************************************");
            logger.error(JSONObject.toJSON(msglist).toString());
            logger.error("************************************************************");
        }
        finally {
            MESSAGELIST.remove();
        }
    }

    private static void doEventCommit() {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        try {
            if (eventlist != null) {
                for (ApplicationEvent event : eventlist) {
                    SpringBeanFactory.getContext().publishEvent(event);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u6d88\u606f\u9519\u8bef!", (Throwable)e);
            logger.error("************************************************************");
            logger.error(JSONObject.toJSON(eventlist).toString());
            logger.error("************************************************************");
        }
        finally {
            EVENTLIST.remove();
        }
    }

    public static void doCommit() {
        EventTransService.doMessageCommit();
        EventTransService.doEventCommit();
    }

    static {
        logger = LoggerFactory.getLogger(EventTransService.class);
        MESSAGELIST = new ThreadLocal();
        EVENTLIST = new ThreadLocal();
    }
}

