/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.service;

import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.MessageConfig;
import com.efuture.ocp.taskcore.service.TaskProducer;
import com.efuture.omd.storage.FStorageOperations;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class TaskUtils {
    public static final String StorageOperation = "StorageOperation_task";
    private static Logger logger = Logger.getLogger(TaskProducer.class);
    private static List<MessageConfig> messageConfig;

    public static FStorageOperations getStorageOperations() {
        return (FStorageOperations)SpringBeanFactory.getBean((String)StorageOperation, FStorageOperations.class);
    }

    public static String getClientKey() {
        String ip = null;
        String port = null;
        try {
            ip = TaskUtils.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            ip = "";
        }
        try {
            port = TaskUtils.getServerPort(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            port = "";
        }
        String ClientKey = ip + ":" + port;
        return ClientKey;
    }

    public static String getHostAddress() throws UnknownHostException {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (!ip.isSiteLocalAddress()) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String getServerPort(boolean secure) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanServer mBeanServer = null;
        if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
            mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
        }
        if (mBeanServer == null) {
            logger.debug((Object)"\u8c03\u7528findMBeanServer\u67e5\u8be2\u5230\u7684\u7ed3\u679c\u4e3anull");
            return "";
        }
        Set<ObjectName> names = null;
        try {
            names = mBeanServer.queryNames(new ObjectName("Catalina:type=Connector,*"), null);
        }
        catch (Exception e) {
            return "";
        }
        Iterator<ObjectName> it = names.iterator();
        ObjectName oname = null;
        while (it.hasNext()) {
            oname = it.next();
            String protocol = (String)mBeanServer.getAttribute(oname, "protocol");
            String scheme = (String)mBeanServer.getAttribute(oname, "scheme");
            Boolean secureValue = (Boolean)mBeanServer.getAttribute(oname, "secure");
            Boolean SSLEnabled = (Boolean)mBeanServer.getAttribute(oname, "SSLEnabled");
            if (SSLEnabled != null && SSLEnabled.booleanValue()) {
                secureValue = true;
                scheme = "https";
            }
            if (protocol == null || !"HTTP/1.1".equals(protocol) && !protocol.contains("http")) continue;
            if (secure && "https".equals(scheme) && secureValue.booleanValue()) {
                return ((Integer)mBeanServer.getAttribute(oname, "port")).toString();
            }
            if (secure || "https".equals(scheme) || secureValue.booleanValue()) continue;
            return ((Integer)mBeanServer.getAttribute(oname, "port")).toString();
        }
        return "";
    }

    private static synchronized void initMessageConfig() {
        if (messageConfig == null) {
            Criteria criteria = Criteria.where((String)"topicstatus").is((Object)"Y");
            Query query = new Query((CriteriaDefinition)criteria);
            messageConfig = TaskUtils.getStorageOperations().select(query, MessageConfig.class, "message_config");
        }
    }

    private static List<MessageConfig> getMessageConfig() {
        if (messageConfig == null) {
            TaskUtils.initMessageConfig();
        }
        return messageConfig;
    }

    public static MessageConfig getMessageConfigbyTopic(String topic) {
        List<MessageConfig> config = TaskUtils.getMessageConfig();
        if (config == null || config.size() < 1) {
            return null;
        }
        for (int i = 0; i < config.size(); ++i) {
            if (!config.get(i).getTopic().equalsIgnoreCase(topic)) continue;
            MessageConfig rtn = config.get(i);
            return rtn;
        }
        return null;
    }

    public static List<MessageConfig> getMessageConfigbyEvent(String event) {
        List<MessageConfig> config = TaskUtils.getMessageConfig();
        if (config == null || config.size() < 1) {
            return null;
        }
        ArrayList<MessageConfig> rtn = new ArrayList<MessageConfig>();
        for (int i = 0; i < config.size(); ++i) {
            if (!config.get(i).getEvent().equalsIgnoreCase(event)) continue;
            rtn.add(config.get(i));
        }
        return rtn;
    }
}

