package com.efuture.msboot.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.base.exception.BaseException;
import com.efuture.msboot.client.ServiceAccess;
import com.efuture.msboot.core.reflect.ComponentInvoker;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

/**
 * Created by wzm on 2019/4/28.
 * 适用于 多个微服务项目打包成一个jar。 服务间调用
 */
@Slf4j
public class LocalServiceAccessImpl implements ServiceAccess {
    @Lazy
    @Autowired(required = false)
    protected ComponentInvoker componentInvoker;

    @Override
    public String doRest(String service, String method, String body) {
        JSONObject jsonParam = JSONObject.parseObject(body);

        JSONObject jsonResponse = doRest(service, method, jsonParam);

        return jsonResponse.toString();
    }

    @Override
    public JSONObject doRest(String service, String method, JSONObject body) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("returncode", "0");

        try {
            Object result = componentInvoker.invoke(method, body);
            if(result == null){
                jsonResponse.put("data", null);
            }

            jsonResponse.put("data", JSONObject.toJSON(result));
        }
        catch (BaseException e){
            jsonResponse.put("returncode", e.getCode());
            jsonResponse.put("data", e.getMessage());
        }
        catch (Exception e){
            jsonResponse.put("returncode","-1");
            jsonResponse.put("data", e.getMessage());
        }

        return jsonResponse;
    }

    @Override
    public <T> T doRest(String service, String method, Object request, Class responseClazz) {
        JSONObject jsonObject = doRest(service, method, (JSONObject)JSONObject.toJSON(request));
        String returnCode = jsonObject.getString("returncode");
        String message = "";

        if(!returnCode.equals("0") && !returnCode.equals("0000")){
            if(jsonObject.containsKey("message")) {
                message = jsonObject.getString("message");
            }else{
                message = jsonObject.getString("data");
            }

            throw new BaseException(returnCode, message);
        }

        //返回空
        if(responseClazz == null || responseClazz.equals(Void.class)){
            return null;
        }

        Object data = jsonObject.get("data");
        if(data == null){
            return null;
        }

        if(data instanceof JSONObject){
            return (T)JSON.parseObject(data.toString(), responseClazz);
        }else if(data instanceof JSONArray){
            return (T)JSON.parseArray(data.toString(), responseClazz);
        }else{
            return (T)(TypeUtils.cast(data, responseClazz, null));
        }
    }
}
