package com.efuture.msboot.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.base.exception.BaseException;
import com.efuture.msboot.client.ServiceAccess;
import com.efuture.msboot.core.utils.DiscoveryRestUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

/**
 * Created by Guanwf on 2018/8/30.
 */
@Slf4j
public class ServiceAccessImpl implements ServiceAccess {
    RestTemplate restTemplate;

    public ServiceAccessImpl(){}

    public ServiceAccessImpl(RestTemplate restTemplate){
        this.restTemplate = restTemplate;
    }


    @Override
    public <T> T doRest(String service, String method, Object request, Class responseClazz) {
        String body = JSON.toJSONString(request);
        String strResponse = doRest(service, method, body);

        JSONObject jsonObject = JSON.parseObject(strResponse);
        String returnCode = jsonObject.getString("returncode");
        String message = "";

        if(!returnCode.equals("0") && !returnCode.equals("0000")){
            if(jsonObject.containsKey("message")) {
                message = jsonObject.getString("message");
            }else{
                message = jsonObject.getString("data");
            }
            throw new BaseException(returnCode, message);
        }

        //返回空
        if(responseClazz == null || responseClazz.equals(Void.class)){
            return null;
        }

        Object data = jsonObject.get("data");
        if(data == null){
            return null;
        }

        if(data instanceof JSONObject){
            return (T)JSON.parseObject(data.toString(), responseClazz);
        }else if(data instanceof JSONArray){
            return (T)JSON.parseArray(data.toString(), responseClazz);
        }else{
            return (T)(TypeUtils.cast(data, responseClazz, null));
        }
    }

    /**
     * 访问微服务接口
     * String url="/rest?method=mdm.demo.get&token=e93aae35-3360-4cb7-bbf2-10f3825e3d87&ent_id=0";
     * String body="{id:2}";
     *
     * @param service 微服服务名称
     * @param method 方法名称
     * @param body JSON格式参数
     * @return
     */
    public String doRest(String service, String method, String body){
        Assert.hasText(service, "service 不能为空");
        Assert.hasText(method, "method 不能为空");

        StringBuilder stringBuilder = new StringBuilder();
        SessionContext sessionContext = SessionContextHolder.get();

        if(sessionContext != null){
            stringBuilder.append("&ent_id="+(StringUtils.hasText(sessionContext.getEntId())?sessionContext.getEntId():"" ));
            stringBuilder.append("&user_id="+(StringUtils.hasText(sessionContext.getUserId())?sessionContext.getUserId():"" ));
            stringBuilder.append("&user_name="+(StringUtils.hasText(sessionContext.getUserName())?sessionContext.getUserName():"" ));
            stringBuilder.append("&token="+(StringUtils.hasText(sessionContext.getToken())?sessionContext.getToken():"" ));

            if(StringUtils.hasText(sessionContext.getSession())) {
                String str = sessionContext.getSession();

                // session 使用 urlencode 编码
                if(!str.startsWith("%7B%22")) {
                    str = DiscoveryRestUtils.onURLEncode(sessionContext.getSession(), "utf-8");
                }

                stringBuilder.append("&session=" + str);
            }
        }

        ResponseEntity<String> responseEntity=null;
        try{
            String url = "http://"+service.toString().trim()+"/rest?method=" + method + stringBuilder.toString();
            log.info(">>调用服务:"+url);

            responseEntity=restTemplate.postForEntity(url, StringUtils.hasText(body)?body:"{}", String.class);
        }catch(Exception ex){
            log.error(">>调用服务异常:"+ex.getMessage());

            throw new BaseException("-1", ex.getMessage(), ex);
        }
        return responseEntity.getBody();
    }

    @Override
    public JSONObject doRest(String service, String method, JSONObject body) {
        String strResponse = doRest(service, method, body.toString());

        return JSON.parseObject(strResponse);
    }

}
