/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.client.config;

import com.efuture.msboot.client.ServiceAccess;
import com.efuture.msboot.client.impl.ServiceAccessImpl;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class MsBootClientConfig {
    @ConditionalOnMissingBean
    @Bean
    public ServiceAccess serviceAccess() {
        return new ServiceAccessImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    @LoadBalanced
    public RestTemplate restTempldate() {
        SimpleClientHttpRequestFactory httpRequestFactory = new SimpleClientHttpRequestFactory();
        httpRequestFactory.setReadTimeout(60000);
        httpRequestFactory.setConnectTimeout(10000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }
}

