/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.base.exception.BaseException;
import com.efuture.msboot.client.ServiceAccess;
import com.efuture.msboot.core.reflect.ComponentInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class LocalServiceAccessImpl
implements ServiceAccess {
    private static final Logger log = LoggerFactory.getLogger(LocalServiceAccessImpl.class);
    @Lazy
    @Autowired(required=false)
    protected ComponentInvoker componentInvoker;

    @Override
    public String doRest(String service, String method, String body) {
        JSONObject jsonParam = JSONObject.parseObject((String)body);
        JSONObject jsonResponse = this.doRest(service, method, jsonParam);
        return jsonResponse.toString();
    }

    @Override
    public JSONObject doRest(String service, String method, JSONObject body) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("returncode", (Object)"0");
        try {
            Object result = this.componentInvoker.invoke(method, body);
            if (result == null) {
                jsonResponse.put("data", null);
            }
            jsonResponse.put("data", JSONObject.toJSON((Object)result));
        }
        catch (BaseException e) {
            jsonResponse.put("returncode", (Object)e.getCode());
            jsonResponse.put("data", (Object)e.getMessage());
        }
        catch (Exception e) {
            jsonResponse.put("returncode", (Object)"-1");
            jsonResponse.put("data", (Object)e.getMessage());
        }
        return jsonResponse;
    }

    @Override
    public <T> T doRest(String service, String method, Object request, Class responseClazz) {
        JSONObject jsonObject = this.doRest(service, method, (JSONObject)JSONObject.toJSON((Object)request));
        String returnCode = jsonObject.getString("returncode");
        String message = "";
        if (!returnCode.equals("0") && !returnCode.equals("0000")) {
            message = jsonObject.containsKey((Object)"message") ? jsonObject.getString("message") : jsonObject.getString("data");
            throw new BaseException(returnCode, message);
        }
        if (responseClazz == null || responseClazz.equals(Void.class)) {
            return null;
        }
        Object data = jsonObject.get((Object)"data");
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return (T)JSON.parseObject((String)data.toString(), (Class)responseClazz);
        }
        if (data instanceof JSONArray) {
            return (T)JSON.parseArray((String)data.toString(), (Class)responseClazz);
        }
        return (T)TypeUtils.cast((Object)data, (Class)responseClazz, null);
    }
}

