/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.base.exception.BaseException;
import com.efuture.msboot.client.ServiceAccess;
import com.efuture.msboot.core.utils.DiscoveryRestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class ServiceAccessImpl
implements ServiceAccess {
    private static final Logger log = LoggerFactory.getLogger(ServiceAccessImpl.class);
    RestTemplate restTemplate;

    public ServiceAccessImpl() {
    }

    public ServiceAccessImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public <T> T doRest(String service, String method, Object request, Class responseClazz) {
        String body = JSON.toJSONString((Object)request);
        String strResponse = this.doRest(service, method, body);
        JSONObject jsonObject = JSON.parseObject((String)strResponse);
        String returnCode = jsonObject.getString("returncode");
        String message = "";
        if (!returnCode.equals("0") && !returnCode.equals("0000")) {
            message = jsonObject.containsKey((Object)"message") ? jsonObject.getString("message") : jsonObject.getString("data");
            throw new BaseException(returnCode, message);
        }
        if (responseClazz == null || responseClazz.equals(Void.class)) {
            return null;
        }
        Object data = jsonObject.get((Object)"data");
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return (T)JSON.parseObject((String)data.toString(), (Class)responseClazz);
        }
        if (data instanceof JSONArray) {
            return (T)JSON.parseArray((String)data.toString(), (Class)responseClazz);
        }
        return (T)TypeUtils.cast((Object)data, (Class)responseClazz, null);
    }

    @Override
    public String doRest(String service, String method, String body) {
        Assert.hasText((String)service, (String)"service \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)method, (String)"method \u4e0d\u80fd\u4e3a\u7a7a");
        StringBuilder stringBuilder = new StringBuilder();
        SessionContext sessionContext = SessionContextHolder.get();
        if (sessionContext != null) {
            stringBuilder.append("&ent_id=" + (StringUtils.hasText((String)sessionContext.getEntId()) ? sessionContext.getEntId() : ""));
            stringBuilder.append("&user_id=" + (StringUtils.hasText((String)sessionContext.getUserId()) ? sessionContext.getUserId() : ""));
            stringBuilder.append("&user_name=" + (StringUtils.hasText((String)sessionContext.getUserName()) ? sessionContext.getUserName() : ""));
            stringBuilder.append("&token=" + (StringUtils.hasText((String)sessionContext.getToken()) ? sessionContext.getToken() : ""));
            if (StringUtils.hasText((String)sessionContext.getSession())) {
                String str = sessionContext.getSession();
                if (!str.startsWith("%7B%22")) {
                    str = DiscoveryRestUtils.onURLEncode((String)sessionContext.getSession(), (String)"utf-8");
                }
                stringBuilder.append("&session=" + str);
            }
        }
        ResponseEntity responseEntity = null;
        try {
            String url = "http://" + service.toString().trim() + "/rest?method=" + method + stringBuilder.toString();
            log.info(">>\u8c03\u7528\u670d\u52a1:" + url);
            responseEntity = this.restTemplate.postForEntity(url, (Object)(StringUtils.hasText((String)body) ? body : "{}"), String.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error(">>\u8c03\u7528\u670d\u52a1\u5f02\u5e38:" + ex.getMessage());
            throw new BaseException("-1", ex.getMessage(), (Throwable)ex);
        }
        return (String)responseEntity.getBody();
    }

    @Override
    public JSONObject doRest(String service, String method, JSONObject body) {
        String strResponse = this.doRest(service, method, body.toString());
        return JSON.parseObject((String)strResponse);
    }
}

