/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connMgr;
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 5000;
    private static final int MAX_READ_TIMEOUT = 60000;

    public static String doGet(String url) {
        return HttpUtil.doGet(url, new HashMap<String, Object>(), null);
    }

    public static String doGet(String url, Map<String, Object> params) {
        return HttpUtil.doGet(url, params, null);
    }

    public static String doGet(String url, Map<String, Object> params, HttpHost proxy) {
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                param.append("?");
            } else {
                param.append("&");
            }
            param.append(key).append("=").append(params.get(key));
            ++i;
        }
        apiUrl = apiUrl + param;
        String result = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpPost = new HttpGet(apiUrl);
            if (proxy != null) {
                httpPost.setConfig(HttpUtil.getRequestConfig(proxy));
            }
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            logger.debug("\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    public static String doPost(String apiUrl) {
        return HttpUtil.doPost(apiUrl, new HashMap<String, Object>(), null);
    }

    public static String doPost(String apiUrl, Map<String, Object> params) {
        return HttpUtil.doPost(apiUrl, params, null);
    }

    public static String doPost(String apiUrl, Map<String, Object> params, HttpHost proxy) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
            Iterator<Map.Entry<String, Object>> iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry;
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), (entry = iterator.next()).getValue() == null ? "" : entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, "UTF-8"));
            if (proxy != null) {
                httpPost.setConfig(HttpUtil.getRequestConfig(proxy));
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
        return httpStr;
    }

    private static RequestConfig getRequestConfig(HttpHost proxy) {
        int httpTimeOutTime = 3;
        RequestConfig.Builder builder = RequestConfig.custom().setSocketTimeout(1000 * httpTimeOutTime).setConnectTimeout(1000 * httpTimeOutTime).setConnectionRequestTimeout(1000 * httpTimeOutTime);
        if (proxy != null) {
            builder = builder.setProxy(proxy);
        }
        return builder.build();
    }

    public static String doPost(String apiUrl, Object json) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            logger.debug(response.getStatusLine().getStatusCode() + "");
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGetSSL(String apiUrl, Map<String, Object> params) {
        StringBuffer paramsSb = new StringBuffer();
        for (String s : params.keySet()) {
            paramsSb.append(s);
            paramsSb.append("=");
            paramsSb.append(params.get(s).toString());
            paramsSb.append("&");
        }
        if (paramsSb.length() > 0) {
            paramsSb.deleteCharAt(paramsSb.length() - 1);
            apiUrl = apiUrl + "?" + paramsSb.toString();
        }
        CloseableHttpClient httpClient = HttpUtil.createHttpClient();
        HttpGet httpGet = new HttpGet(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            return httpStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
        CloseableHttpClient httpClient = HttpUtil.createHttpClient();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("utf-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = response.toString();
                return string;
            }
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
            return httpStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostSSL(String apiUrl, Object json) {
        CloseableHttpClient httpClient = HttpUtil.createHttpClient();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            return httpStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static CloseableHttpClient createHttpClient() {
        SSLConnectionSocketFactory sslConnSocketFactory = HttpUtil.createSSLConnSocketFactory();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnSocketFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(cm.getMaxTotal());
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnSocketFactory).setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sslsf;
    }

    static {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(5000);
        configBuilder.setSocketTimeout(60000);
        configBuilder.setConnectionRequestTimeout(5000);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }
}

