/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.config;

import com.baomidou.mybatisplus.mapper.ISqlInjector;
import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.plugins.parser.AbstractJsqlParser;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.data.ViewAccess;
import com.efuture.msboot.data.config.DataAccessProperties;
import com.efuture.msboot.data.dbswitcher.aop.DbSwitcherAop;
import com.efuture.msboot.data.dbswitcher.config.YamlDbSwitcherConfigurationProperties;
import com.efuture.msboot.data.dbswitcher.parser.MycatSqlParser;
import com.efuture.msboot.data.impl.MyBatisDataAccess;
import com.efuture.msboot.data.impl.MyBatisViewAccess;
import com.efuture.msboot.data.mybatis.AutoSqlInjectorPlus;
import com.efuture.msboot.data.permission.PermissionDefineService;
import com.efuture.msboot.data.permission.PermissionResourceService;
import com.efuture.msboot.data.permission.config.YamlPermissionConfigurationProperties;
import com.efuture.msboot.data.permission.impl.PermissionResourceServiceImpl;
import com.efuture.msboot.data.permission.impl.YmlPermissionDefineServiceImpl;
import com.efuture.msboot.data.permission.parser.ResourceSqlParser;
import com.efuture.msboot.data.query.QueryBuilder;
import com.efuture.msboot.data.query.SqlBuilder;
import com.efuture.msboot.data.query.impl.DefaultSqlBuilder;
import com.efuture.msboot.data.query.impl.SqlQueryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={YamlPermissionConfigurationProperties.class, YamlDbSwitcherConfigurationProperties.class})
public class MsBootDataConfig
implements EnvironmentAware {
    @Autowired
    YamlPermissionConfigurationProperties yamlPermissionConfigurationProperties;
    @Autowired
    YamlDbSwitcherConfigurationProperties yamlDbSwitcherConfigurationProperties;

    @Bean
    @ConditionalOnMissingBean
    public DataAccess dataAccess() {
        return new MyBatisDataAccess();
    }

    @Bean
    @ConditionalOnMissingBean
    public ViewAccess viewAccess() {
        return new MyBatisViewAccess();
    }

    @Bean
    @ConditionalOnMissingBean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLocalPage(true);
        ArrayList<AbstractJsqlParser> sqlParserList = new ArrayList<AbstractJsqlParser>();
        if (this.yamlPermissionConfigurationProperties.getFilterEnable().booleanValue()) {
            sqlParserList.add(this.resourceSqlParser());
        }
        if (this.yamlDbSwitcherConfigurationProperties.getEnable().booleanValue() && "mycat".equalsIgnoreCase(this.yamlDbSwitcherConfigurationProperties.getType())) {
            String[] tables;
            MycatSqlParser mycatSqlParser = this.mycatSqlParser();
            if (StringUtils.hasText((String)this.yamlDbSwitcherConfigurationProperties.getMasterTables())) {
                tables = this.yamlDbSwitcherConfigurationProperties.getMasterTables().split(",");
                mycatSqlParser.setMasterTableSet(new HashSet<String>());
                for (String t : tables) {
                    if (!StringUtils.hasText((String)t)) continue;
                    mycatSqlParser.getMasterTableSet().add(t.toLowerCase());
                }
            }
            if (StringUtils.hasText((String)this.yamlDbSwitcherConfigurationProperties.getSlaveTables())) {
                tables = this.yamlDbSwitcherConfigurationProperties.getSlaveTables().split(",");
                mycatSqlParser.setSlaveTableSet(new HashSet<String>());
                for (String t : tables) {
                    if (!StringUtils.hasText((String)t)) continue;
                    mycatSqlParser.getSlaveTableSet().add(t.toLowerCase());
                }
            }
            sqlParserList.add(mycatSqlParser);
        }
        if (!CollectionUtils.isEmpty(sqlParserList)) {
            paginationInterceptor.setSqlParserList(sqlParserList);
        }
        return paginationInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public ISqlInjector sqlInjector() {
        return new AutoSqlInjectorPlus();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryBuilder queryBuilder() {
        return new SqlQueryBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlBuilder sqlBuilder() {
        return new DefaultSqlBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataAccessProperties dataAccessProperties() {
        return new DataAccessProperties();
    }

    public void setEnvironment(Environment environment) {
    }

    @Bean
    @ConditionalOnMissingBean
    public PermissionDefineService authDefineService() {
        return new YmlPermissionDefineServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResourceSqlParser resourceSqlParser() {
        return new ResourceSqlParser();
    }

    @Bean
    @ConditionalOnMissingBean
    public MycatSqlParser mycatSqlParser() {
        return new MycatSqlParser();
    }

    @Bean
    @ConditionalOnMissingBean
    public PermissionResourceService permissionResourceService() {
        return new PermissionResourceServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="msboot.data.dbswitcher", name={"enable"}, havingValue="true")
    public DbSwitcherAop dbSwitcherAop() {
        return new DbSwitcherAop();
    }
}

