/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.dbswitcher.aop;

import com.efuture.msboot.data.annotation.DbSwitcher;
import com.efuture.msboot.data.dbswitcher.context.DbSwitcherContext;
import com.efuture.msboot.data.dbswitcher.context.DbSwitcherContextHolder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class DbSwitcherAop {
    private static final Logger log = LoggerFactory.getLogger(DbSwitcherAop.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.efuture.msboot.data.annotation.DbSwitcher) || within(@com.efuture.msboot.data.annotation.DbSwitcher *)")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            DbSwitcher dbSwitcher = this.getTag(joinPoint);
            if (dbSwitcher != null) {
                DbSwitcherContext mycatContext = new DbSwitcherContext();
                mycatContext.setDbType(dbSwitcher.dbType());
                DbSwitcherContextHolder.put(mycatContext);
            } else {
                log.warn(">> \u83b7\u53d6\u4e0d\u5230 dbSwitcher");
            }
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            DbSwitcherContextHolder.remove();
        }
    }

    private DbSwitcher getTag(ProceedingJoinPoint joinPoint) {
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            DbSwitcher dbSwitcher = signature.getMethod().getAnnotation(DbSwitcher.class);
            if (dbSwitcher != null) {
                return dbSwitcher;
            }
            dbSwitcher = joinPoint.getTarget().getClass().getAnnotation(DbSwitcher.class);
            if (dbSwitcher != null) {
                return dbSwitcher;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

