/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.dbswitcher.context;

import com.efuture.msboot.data.dbswitcher.context.DbSwitcherContext;
import java.util.Stack;
import org.springframework.util.CollectionUtils;

public class DbSwitcherContextHolder {
    private static final ThreadLocal<Stack<DbSwitcherContext>> threadLocal = new InheritableThreadLocal<Stack<DbSwitcherContext>>();

    private DbSwitcherContextHolder() {
    }

    public static DbSwitcherContext get() {
        Stack<DbSwitcherContext> stack = threadLocal.get();
        if (CollectionUtils.isEmpty(stack)) {
            return null;
        }
        return stack.peek();
    }

    public static void put(DbSwitcherContext value) {
        Stack<DbSwitcherContext> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
        }
        stack.push(value);
        threadLocal.set(stack);
    }

    public static void remove() {
        Stack<DbSwitcherContext> stack = threadLocal.get();
        if (stack.empty()) {
            return;
        }
        stack.pop();
    }
}

