/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.dbswitcher.parser;

import com.baomidou.mybatisplus.plugins.parser.AbstractJsqlParser;
import com.baomidou.mybatisplus.plugins.parser.SqlInfo;
import com.efuture.msboot.data.dbswitcher.context.DbSwitcherContextHolder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MycatSqlParser
extends AbstractJsqlParser {
    private static final Logger log = LoggerFactory.getLogger(MycatSqlParser.class);
    private Set<String> masterTableSet;
    private Set<String> slaveTableSet;

    public void processInsert(Insert insert) {
    }

    public void processDelete(Delete delete) {
    }

    public void processUpdate(Update update) {
    }

    public void processSelectBody(SelectBody selectBody) {
    }

    public SqlInfo processParser(Statement statement) {
        String sql;
        String targetSql = sql = statement.toString();
        if (statement instanceof Select && DbSwitcherContextHolder.get() != null) {
            targetSql = this.buildMycatSwitchSql(DbSwitcherContextHolder.get().getDbType(), sql);
        } else if (statement instanceof Select && !CollectionUtils.isEmpty(this.masterTableSet) || !CollectionUtils.isEmpty(this.slaveTableSet)) {
            Set<String> tables = this.getTablesFromSql(statement);
            if (!CollectionUtils.isEmpty(this.masterTableSet) && this.hasSet(tables, this.masterTableSet)) {
                targetSql = this.buildMycatSwitchSql("master", sql);
            } else if (!CollectionUtils.isEmpty(this.slaveTableSet) && this.hasSet(tables, this.slaveTableSet)) {
                targetSql = this.buildMycatSwitchSql("slave", sql);
            }
        }
        if (!sql.equalsIgnoreCase(targetSql)) {
            log.debug(">> mycatSqlParser: {}", (Object)targetSql);
        }
        return SqlInfo.newInstance().setSql(targetSql);
    }

    private String buildMycatSwitchSql(String dbtype, String sql) {
        if (dbtype.equalsIgnoreCase("master")) {
            return "/*#mycat:db_type=master*/" + sql;
        }
        if (dbtype.equalsIgnoreCase("slave")) {
            return "/*#mycat:db_type=slave*/" + sql;
        }
        return sql;
    }

    private Set<String> getTablesFromSql(Statement statement) {
        HashSet<String> tables = new HashSet<String>();
        try {
            Select selectStatement = (Select)statement;
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            List tableList = tablesNamesFinder.getTableList((Statement)selectStatement);
            for (String tableName : tableList) {
                if (!StringUtils.hasText((String)tableName)) continue;
                tables.add(tableName.toLowerCase().trim());
            }
        }
        catch (Exception e) {
            log.error(">> \u83b7\u53d6\u8868\u9519\u8bef");
            log.error(e.getMessage(), (Throwable)e);
        }
        return tables;
    }

    private boolean hasSet(Set<String> set1, Set<String> set2) {
        if (CollectionUtils.isEmpty(set1) || CollectionUtils.isEmpty(set2)) {
            return false;
        }
        for (String str : set1) {
            if (!set2.contains(str)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getMasterTableSet() {
        return this.masterTableSet;
    }

    public void setMasterTableSet(Set<String> masterTableSet) {
        this.masterTableSet = masterTableSet;
    }

    public Set<String> getSlaveTableSet() {
        return this.slaveTableSet;
    }

    public void setSlaveTableSet(Set<String> slaveTableSet) {
        this.slaveTableSet = slaveTableSet;
    }
}

