/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.impl;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.reflect.utils.ReflectUtils;
import com.efuture.msboot.core.utils.BeanMapUtils;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.core.utils.StringUtils;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.data.annotation.TablePrimaryKey;
import com.efuture.msboot.data.bean.CURDEntity;
import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.bean.EntityDBInfo;
import com.efuture.msboot.data.bean.PageQuery;
import com.efuture.msboot.data.bean.Query;
import com.efuture.msboot.data.bean.SlaveInfo;
import com.efuture.msboot.data.config.DataAccessProperties;
import com.efuture.msboot.data.enums.MapKeyType;
import com.efuture.msboot.data.mybatis.PlusMapper;
import com.efuture.msboot.data.utils.EntityDBInfoUtils;
import com.efuture.msboot.data.utils.EntityUtils;
import com.efuture.msboot.data.utils.SlaveUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MyBatisDataAccess
implements DataAccess,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MyBatisDataAccess.class);
    private ApplicationContext applicationContext;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    DataAccessProperties dataAccessProperties;

    public MyBatisDataAccess() {
    }

    public MyBatisDataAccess(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public MyBatisDataAccess(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    @Override
    public <T> Integer insert(T entity) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        return this.getMapper(entity.getClass()).insert(entity);
    }

    @Override
    public <T> Integer insert(T entity, Boolean insertSlave) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        int effect = this.insert(entity);
        if (!insertSlave.booleanValue()) {
            return effect;
        }
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(entity.getClass());
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return effect;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
        for (SlaveInfo slaveInfo : slaveInfoList) {
            List slaveList;
            if (CollectionUtils.isEmpty(slaveInfo.getRefFields()) || CollectionUtils.isEmpty((Collection)(slaveList = (List)beanWrapper.getPropertyValue(slaveInfo.getFieldName())))) continue;
            for (Object slaveObj : slaveList) {
                effect += this.insert(slaveObj).intValue();
            }
        }
        return effect;
    }

    @Override
    public <T> Integer insertAllColumn(T entity) {
        return this.getMapper(entity.getClass()).insertAllColumn(entity);
    }

    @Override
    public <T> Integer deleteById(Serializable id, Class<T> entityClass) {
        if (ReflectUtils.isJavaBean(id.getClass())) {
            if (this.hasTablePrimaryKey(id.getClass())) {
                Query<T> idQuery = this.buildIdQuery(id, entityClass);
                return this.delete(idQuery, entityClass);
            }
            Serializable idValue = EntityUtils.getIdValue(id);
            if (idValue == null) {
                ExceptionUtils.raise((String)"id \u4e3a\u7a7a");
            }
            return this.getMapper(entityClass).deleteById(idValue);
        }
        return this.getMapper(entityClass).deleteById(id);
    }

    @Override
    public <T> Integer deleteById(Serializable id, Class<T> entityClass, Boolean deleteSlave) {
        T master = this.selectById(id, entityClass, true);
        if (master == null) {
            return 0;
        }
        Integer effect = this.deleteById(id, entityClass);
        if (!deleteSlave.booleanValue()) {
            return effect;
        }
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(entityClass);
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return effect;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(master);
        for (SlaveInfo slaveInfo : slaveInfoList) {
            if (CollectionUtils.isEmpty(slaveInfo.getRefFields())) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String refField : slaveInfo.getRefFields()) {
                params.put(refField, beanWrapper.getPropertyValue(refField));
            }
            effect = effect + this.deleteByMap(params, slaveInfo.getSlaveClazz());
        }
        return effect;
    }

    @Override
    public <T> Integer deleteByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        return this.getMapper(entityClass).deleteByMap(columnMap);
    }

    @Override
    public <T> Integer delete(Query<T> query, Class<T> entityClass) {
        return this.getMapper(entityClass).delete((Wrapper)query);
    }

    @Override
    public <T> Integer deleteBatchIds(Collection<? extends Serializable> idList, Class<T> entityClass) {
        Iterator<? extends Serializable> iterator = idList.iterator();
        int effect = 0;
        while (iterator.hasNext()) {
            Class<?> clazz;
            Serializable obj = iterator.next();
            if (obj == null) {
                ExceptionUtils.raise((String)"id \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ReflectUtils.isJavaBean(clazz = obj.getClass())) break;
            effect += this.deleteById(obj, clazz).intValue();
        }
        if (effect > 0) {
            return effect;
        }
        return this.getMapper(entityClass).deleteBatchIds(idList);
    }

    @Override
    public <T> Integer updateById(T entity) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        Class<?> entityClass = entity.getClass();
        if (this.hasTablePrimaryKey(entityClass)) {
            Query<?> idQuery = this.buildIdQuery(entity, entityClass);
            return this.update(entity, idQuery);
        }
        return this.getMapper(entity.getClass()).updateById(entity);
    }

    @Override
    public <T> Integer updateById(T entity, Boolean updateSlave) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        int effect = this.updateById(entity);
        if (effect == 0 || !updateSlave.booleanValue()) {
            return effect;
        }
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(entity.getClass());
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return effect;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
        for (SlaveInfo slaveInfo : slaveInfoList) {
            List slaveList;
            if (CollectionUtils.isEmpty(slaveInfo.getRefFields()) || CollectionUtils.isEmpty((Collection)(slaveList = (List)beanWrapper.getPropertyValue(slaveInfo.getFieldName())))) continue;
            for (Object slaveObj : slaveList) {
                effect += this.updateById(slaveObj).intValue();
            }
        }
        return effect;
    }

    @Override
    public <T> Integer updateAllColumnById(T entity) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        return this.getMapper(entity.getClass()).updateAllColumnById(entity);
    }

    @Override
    public <T> Integer update(T entity, Query<T> query) {
        Assert.notNull(entity, (String)"entity \u4e0d\u80fd\u4e3a\u7a7a");
        return this.getMapper(entity.getClass()).update(entity, (Wrapper)query);
    }

    @Override
    public <T> Integer updateForSet(String setStr, Query<T> query, Class<T> entityClass) {
        return this.getMapper(entityClass).updateForSet(setStr, (Wrapper)query);
    }

    @Override
    public <T extends CURDEntity> Integer curd(List<T> entityList, Class<T> entityClass) {
        String curdFlag;
        if (CollectionUtils.isEmpty(entityList)) {
            return null;
        }
        int effect = 0;
        for (CURDEntity entity : entityList) {
            curdFlag = entity.getCurd_flag();
            if (!org.springframework.util.StringUtils.hasText((String)curdFlag) || !curdFlag.equalsIgnoreCase("D")) continue;
            effect += this.deleteById(entity, entityClass).intValue();
        }
        for (CURDEntity entity : entityList) {
            curdFlag = entity.getCurd_flag();
            if (!org.springframework.util.StringUtils.hasText((String)curdFlag)) continue;
            if (curdFlag.equalsIgnoreCase("C")) {
                effect += this.insert(entity).intValue();
                continue;
            }
            if (!curdFlag.equalsIgnoreCase("U")) continue;
            effect += this.updateById(entity).intValue();
        }
        return effect;
    }

    @Override
    public <T> T selectById(Serializable id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        if (ReflectUtils.isJavaBean(id.getClass())) {
            if (this.hasTablePrimaryKey(id.getClass())) {
                Query<T> idQuery = this.buildIdQuery(id, entityClass);
                List resultList = this.getMapper(entityClass).selectList((Wrapper)idQuery);
                return CollectionUtils.isEmpty((Collection)resultList) ? null : (T)resultList.get(0);
            }
            Serializable idValue = EntityUtils.getIdValue(id);
            if (idValue == null) {
                ExceptionUtils.raise((String)"id\u503c\u4e3a\u7a7a");
            }
            return (T)this.getMapper(entityClass).selectById(idValue);
        }
        return (T)this.getMapper(entityClass).selectById(id);
    }

    @Override
    public <T> T selectById(Serializable id, Class<T> entityClass, Boolean returnSlave) {
        T master = this.selectById(id, entityClass);
        if (master == null) {
            return null;
        }
        if (!returnSlave.booleanValue()) {
            return master;
        }
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(entityClass);
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return master;
        }
        this.fillSlave(master, entityClass);
        return master;
    }

    @Override
    public <T> List<T> selectBatchIds(@Param(value="coll") Collection<? extends Serializable> idList, Class<T> entityClass) {
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Serializable serializable : idList) {
            Class<?> clazz;
            if (serializable == null) {
                ExceptionUtils.raise((String)"id \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ReflectUtils.isJavaBean(clazz = serializable.getClass())) break;
            Object entity = this.selectById(serializable, clazz);
            result.add(entity);
        }
        if (!CollectionUtils.isEmpty(result)) {
            if (idList.size() != result.size()) {
                ExceptionUtils.raise((String)"selectBatchIds \u9519\u8bef");
            }
            return result;
        }
        return this.getMapper(entityClass).selectBatchIds(idList);
    }

    @Override
    public <T> List<T> selectByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        return this.getMapper(entityClass).selectByMap(columnMap);
    }

    @Override
    public <T> T selectOne(T entity, Class<T> entityClass) {
        return (T)this.getMapper(entityClass).selectOne(entity);
    }

    @Override
    public <T> T selectOne(Query<T> query, Class<T> entityClass) {
        List<T> resultList = this.selectList(query, entityClass);
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        if (resultList.size() > 1) {
            log.warn(">> \u67e5\u8be2\u8fd4\u56de\u591a\u6761\u6570\u636e {}", (Object)resultList.size());
        }
        return resultList.get(0);
    }

    @Override
    public <T> T selectOneByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        List<T> resultList = this.selectByMap(columnMap, entityClass);
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        if (resultList.size() > 1) {
            log.warn(">> \u67e5\u8be2\u8fd4\u56de\u591a\u6761\u6570\u636e {}", (Object)resultList.size());
        }
        return resultList.get(0);
    }

    @Override
    public <T> Integer selectCount(Query<T> query, Class<T> entityClass) {
        return this.getMapper(entityClass).selectCount((Wrapper)query);
    }

    @Override
    public <T> List<T> selectList(Query<T> query, Class<T> entityClass) {
        return this.getMapper(entityClass).selectList((Wrapper)query);
    }

    @Override
    public <T> List<Map<String, Object>> selectMaps(Query<T> query, Class<T> entityClass) {
        return this.getMapper(entityClass).selectMaps((Wrapper)query);
    }

    @Override
    public <T> List<Object> selectObjs(Query<T> query, Class<T> entityClass) {
        return this.getMapper(entityClass).selectObjs((Wrapper)query);
    }

    @Override
    public <T> DataPage<T> selectPage(PageQuery<T> query, Class<T> entityClass) {
        int pageNo = query.getPageNo() <= 0 ? 1 : query.getPageNo();
        int pageSize = query.getPageSize() <= 0 ? Integer.MAX_VALUE : query.getPageSize();
        try {
            PageHelper.startPage((int)query.getPageNo(), (int)query.getPageSize());
            List resultList = this.getMapper(entityClass).selectList((Wrapper)query);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            return dataPage;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public <T> DataPage<T> selectMapsPage(PageQuery<T> query, Class<T> entityClass) {
        int pageNo = query.getPageNo() <= 0 ? 1 : query.getPageNo();
        int pageSize = query.getPageSize() <= 0 ? Integer.MAX_VALUE : query.getPageSize();
        try {
            PageHelper.startPage((int)query.getPageNo(), (int)query.getPageSize());
            List resultList = this.getMapper(entityClass).selectMaps((Wrapper)query);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            return dataPage;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public <T> Object selectMax(String field, Query<T> query, Class<T> entityClass) {
        if (query == null) {
            query = new Query();
        }
        query.setSqlSelect("max(" + field + ")");
        List<Object> resultList = this.selectObjs(query, entityClass);
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        return resultList.get(0);
    }

    @Override
    public <T> void fillSlave(T master, Class<T> entityClass) {
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(entityClass);
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(master);
        for (SlaveInfo slaveInfo : slaveInfoList) {
            if (CollectionUtils.isEmpty(slaveInfo.getRefFields())) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String refField : slaveInfo.getRefFields()) {
                params.put(refField, beanWrapper.getPropertyValue(refField));
            }
            List<T> slaveBeanList = this.selectByMap(params, slaveInfo.getSlaveClazz());
            if (CollectionUtils.isEmpty(slaveBeanList)) continue;
            beanWrapper.setPropertyValue(slaveInfo.getFieldName(), slaveBeanList);
        }
    }

    @Override
    public int insert(String statement, Object parameter) {
        return this.getSqlSessionTemplate().insert(statement, parameter);
    }

    @Override
    public int update(String statement, Object parameter) {
        return this.getSqlSessionTemplate().update(statement, parameter);
    }

    @Override
    public int delete(String statement, Object parameter) {
        return this.getSqlSessionTemplate().delete(statement, parameter);
    }

    @Override
    public <T> List<T> selectList(String statement, Object parameter) {
        return this.getSqlSessionTemplate().selectList(statement, parameter);
    }

    @Override
    public <T> T selectOne(String statement, Object parameter) {
        List resultList = this.getSqlSessionTemplate().selectList(statement, parameter);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        if (resultList.size() > 1) {
            log.warn(">> \u67e5\u8be2\u8fd4\u56de\u591a\u6761\u6570\u636e {}-{}", (Object)statement, (Object)resultList.size());
        }
        return (T)resultList.get(0);
    }

    @Override
    public <T> DataPage<T> selectPage(String statement, int pageNo, int pageSize, Object parameter) {
        try {
            PageHelper.startPage((int)pageNo, (int)pageSize);
            List resultList = this.getSqlSessionTemplate().selectList(statement, parameter);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            return dataPage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public <T> List<T> selectSqlList(String sql, Class<T> entityClass) {
        List<Map> mapList = this.selectSqlMapList(sql, MapKeyType.NATIVE);
        if (CollectionUtils.isEmpty(mapList)) {
            return null;
        }
        ArrayList<Object> beanList = new ArrayList<Object>();
        for (Map map : mapList) {
            Object bean = BeanMapUtils.mapToBean((Map)map, entityClass);
            beanList.add(bean);
        }
        return beanList;
    }

    @Override
    public <T> List<T> selectSqlList(String sqlTemplate, Map<String, Object> paramter, Class<T> entityClass) {
        List<Map> mapList = this.selectSqlMapListByMap(sqlTemplate, paramter);
        if (CollectionUtils.isEmpty(mapList)) {
            return null;
        }
        ArrayList<Object> beanList = new ArrayList<Object>();
        for (Map map : mapList) {
            Object bean = BeanMapUtils.mapToBean((Map)map, entityClass);
            beanList.add(bean);
        }
        return beanList;
    }

    @Override
    public <T> DataPage<T> selectSqlPage(String sql, int pageNo, int pageSize, Class<T> entityClass) {
        try {
            PageHelper.startPage((int)pageNo, (int)pageSize);
            List<T> resultList = this.selectSqlList(sql, entityClass);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            return dataPage;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public <T> DataPage<T> selectSqlPage(String sqlTemplate, Map<String, Object> paramter, int pageNo, int pageSize, Class<T> entityClass) {
        try {
            PageHelper.startPage((int)pageNo, (int)pageSize);
            List<T> resultList = this.selectSqlList(sqlTemplate, paramter, entityClass);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            return dataPage;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public List<Map> selectSqlMapList(String sql) {
        return this.selectSqlMapList(sql, this.dataAccessProperties.getMapKeyType());
    }

    @Override
    public List<Map> selectSqlMapList(String sqlTemplate, Map<String, Object> paramter) {
        return this.selectSqlMapList(sqlTemplate, paramter, this.dataAccessProperties.getMapKeyType());
    }

    @Override
    public List<Map> selectSqlMapList(String sql, MapKeyType mapKeyType) {
        PlusMapper plusMapper = (PlusMapper)this.applicationContext.getBean("dataMapper");
        List<Map> mapList = plusMapper.selectSqlMap(sql);
        this.beautifulMapKey(mapList, sql, mapKeyType);
        return mapList;
    }

    @Override
    public List<Map> selectSqlMapList(String sqlTemplate, Map<String, Object> paramter, MapKeyType mapKeyType) {
        PlusMapper plusMapper = (PlusMapper)this.applicationContext.getBean("dataMapper");
        HashMap<String, Object> map = new HashMap<String, Object>(paramter);
        map.put("sql", sqlTemplate);
        List<Map> mapList = plusMapper.selectSqlMapByMap(map);
        this.beautifulMapKey(mapList, sqlTemplate, mapKeyType);
        return mapList;
    }

    @Override
    public DataPage<Map> selectSqlMapPage(String sql, int pageNo, int pageSize) {
        return this.selectSqlMapPage(sql, pageNo, pageSize, this.dataAccessProperties.getMapKeyType());
    }

    @Override
    public DataPage<Map> selectSqlMapPage(String sqlTemplate, Map<String, Object> paramter, int pageNo, int pageSize) {
        return this.selectSqlMapPage(sqlTemplate, paramter, pageNo, pageSize, this.dataAccessProperties.getMapKeyType());
    }

    @Override
    public DataPage<Map> selectSqlMapPage(String sql, int pageNo, int pageSize, MapKeyType mapKeyType) {
        try {
            PageHelper.startPage((int)pageNo, (int)pageSize);
            List<Map> resultList = this.selectSqlMapList(sql);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            this.beautifulMapKey(dataPage.getPageData(), sql, mapKeyType);
            DataPage dataPage2 = dataPage;
            return dataPage2;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public DataPage<Map> selectSqlMapPage(String sqlTemplate, Map<String, Object> paramter, int pageNo, int pageSize, MapKeyType mapKeyType) {
        try {
            PageHelper.startPage((int)pageNo, (int)pageSize);
            List<Map> resultList = this.selectSqlMapList(sqlTemplate, paramter);
            DataPage dataPage = DataPage.build(pageNo, pageSize, (int)PageHelper.getTotal(), resultList);
            this.beautifulMapKey(dataPage.getPageData(), sqlTemplate, mapKeyType);
            DataPage dataPage2 = dataPage;
            return dataPage2;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            PageHelper.freeTotal();
        }
    }

    @Override
    public List<Map> selectSqlMapListByMap(String sqlTemplate, Map paramter) {
        return this.selectSqlMapListByMap(sqlTemplate, paramter, this.dataAccessProperties.getMapKeyType());
    }

    @Override
    public List<Map> selectSqlMapListByMap(String sqlTemplate, Map paramter, MapKeyType mapKeyType) {
        PlusMapper plusMapper = (PlusMapper)this.applicationContext.getBean("dataMapper");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sql", sqlTemplate);
        if (!CollectionUtils.isEmpty((Map)paramter)) {
            param.putAll(paramter);
        }
        List<Map> mapList = plusMapper.selectSqlMapByMap(param);
        this.beautifulMapKey(mapList, sqlTemplate, mapKeyType);
        return mapList;
    }

    @Override
    public int insertSql(String sql) {
        PlusMapper plusMapper = (PlusMapper)this.applicationContext.getBean("dataMapper");
        return plusMapper.insertSql(sql);
    }

    @Override
    public int updateSql(String sql) {
        PlusMapper plusMapper = (PlusMapper)this.applicationContext.getBean("dataMapper");
        return plusMapper.updateSql(sql);
    }

    @Override
    public int deleteSql(String sql) {
        PlusMapper plusMapper = (PlusMapper)this.applicationContext.getBean("dataMapper");
        return plusMapper.deleteSql(sql);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private PlusMapper getMapper(Class entityClass) {
        String mapperName = StringUtils.lowerFirst((String)(entityClass.getSimpleName() + "Mapper"));
        return (PlusMapper)this.applicationContext.getBean(mapperName);
    }

    private SqlSessionFactory getSqlSessionFactory() {
        if (this.sqlSessionFactory != null) {
            return this.sqlSessionFactory;
        }
        return (SqlSessionFactory)this.applicationContext.getBean(SqlSessionFactory.class);
    }

    private SqlSessionTemplate getSqlSessionTemplate() {
        if (this.sqlSessionTemplate != null) {
            return this.sqlSessionTemplate;
        }
        return (SqlSessionTemplate)this.applicationContext.getBean(SqlSessionTemplate.class);
    }

    private boolean hasTablePrimaryKey(Class entityClass) {
        TablePrimaryKey tablePrimaryKey = entityClass.getAnnotation(TablePrimaryKey.class);
        return tablePrimaryKey != null;
    }

    private <T> Query<T> buildIdQuery(Object id, Class<T> entityClass) {
        TablePrimaryKey tablePrimaryKey = entityClass.getAnnotation(TablePrimaryKey.class);
        EntityDBInfo entityDBInfo = EntityDBInfoUtils.getEntityDBInfo(entityClass);
        Query query = new Query();
        Wrapper wrapper = null;
        EasyBeanWrapper easyBeanWrapper = new EasyBeanWrapper(id);
        for (String key : tablePrimaryKey.keys()) {
            if (!easyBeanWrapper.getPropertiesSet().contains(key)) {
                ExceptionUtils.raise((String)("\u6ca1\u6709\u5b57\u6bb5" + key));
            }
            Object value = easyBeanWrapper.getPropertyValue(key);
            String column = key;
            if (entityDBInfo.getFieldColumnMap().containsKey(key)) {
                column = entityDBInfo.getFieldColumnMap().get(key);
            }
            wrapper = wrapper == null ? query.eq(column, value) : wrapper.and().eq(column, value);
        }
        return query;
    }

    private void beautifulMapKey(List<Map> mapList, String sql, MapKeyType mapKeyType) {
        if (CollectionUtils.isEmpty(mapList)) {
            return;
        }
        if (mapKeyType == MapKeyType.UPCASE) {
            return;
        }
        if (mapKeyType == MapKeyType.LOWCASE) {
            for (Map item2 : mapList) {
                if (item2 == null) continue;
                ArrayList columns = new ArrayList(item2.keySet());
                columns.forEach(column -> {
                    String lowcaseKey = column.toLowerCase();
                    if (!lowcaseKey.equals(column)) {
                        item2.put(lowcaseKey, item2.get(column));
                        item2.remove(column);
                    }
                });
            }
        } else if (mapKeyType == MapKeyType.NATIVE) {
            String dbType = "mysql";
            SQLStatement stmt = (SQLStatement)SQLUtils.parseStatements((String)sql, (String)dbType).get(0);
            MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
            stmt.accept((SQLASTVisitor)visitor);
            ArrayList columnName = new ArrayList();
            List selectItemList = ((SQLSelectQueryBlock)((SQLSelectStatement)stmt).getSelect().getQuery()).getSelectList();
            selectItemList.forEach(item -> {
                String colunmname = null;
                colunmname = item.getExpr() instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)item.getExpr()).getName() : (item.getExpr() instanceof SQLPropertyExpr ? ((SQLPropertyExpr)item.getExpr()).getName() : item.toString());
                if (org.springframework.util.StringUtils.hasText((String)item.getAlias())) {
                    columnName.add(item.getAlias());
                } else {
                    columnName.add(colunmname);
                }
            });
            mapList.forEach(item -> {
                if (item == null) {
                    return;
                }
                columnName.forEach(cn -> {
                    if (cn.equals("*")) {
                        return;
                    }
                    String mapKey = cn.toUpperCase();
                    if (item.containsKey(mapKey) && !mapKey.equals(cn)) {
                        item.put(cn, item.get(mapKey));
                        item.remove(mapKey);
                    }
                });
            });
        }
    }
}

