/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.impl;

import com.efuture.msboot.core.reflect.utils.ReflectUtils;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.data.ViewAccess;
import com.efuture.msboot.data.bean.SlaveInfo;
import com.efuture.msboot.data.query.SqlBuilder;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.data.utils.EntityUtils;
import com.efuture.msboot.data.utils.SlaveUtils;
import com.efuture.msboot.data.utils.ViewUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MyBatisViewAccess
implements ViewAccess,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Lazy
    @Autowired(required=false)
    private DataAccess dataAccess;
    @Autowired
    private SqlBuilder sqlBuilder;

    @Override
    public <T> T selectById(Serializable id, Class<T> viewClass) {
        if (!this.isView(viewClass).booleanValue()) {
            return this.dataAccess.selectById(id, viewClass);
        }
        Map<String, Object> map = null;
        if (ReflectUtils.isJavaBean(id.getClass())) {
            map = EntityUtils.getIdValueMap(id);
        } else {
            map = new HashMap<String, Object>();
            map.put(EntityUtils.getIdField(viewClass), id);
        }
        List<T> resultList = this.selectByMap(map, viewClass);
        return CollectionUtils.isEmpty(resultList) ? null : (T)resultList.get(0);
    }

    @Override
    public <T> T selectById(Serializable id, Class<T> viewClass, Boolean returnSlave) {
        T master = this.selectById(id, viewClass);
        if (master == null) {
            return null;
        }
        if (!returnSlave.booleanValue()) {
            return master;
        }
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(viewClass);
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return master;
        }
        this.fillSlave(master);
        return master;
    }

    @Override
    public <T> List<T> selectByMap(Map<String, Object> columnMap, Class<T> viewClass) {
        Assert.notNull(columnMap);
        SearchInfo searchInfo = new SearchInfo();
        searchInfo.setEntityClazz(viewClass);
        searchInfo.setParams(columnMap);
        String sqlTemplate = this.sqlBuilder.buildSqlTemplate(searchInfo);
        return this.dataAccess.selectSqlList(sqlTemplate, searchInfo.getParams(), viewClass);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Boolean isView(Class clazz) {
        return ViewUtils.isView(clazz);
    }

    private <T> void fillSlave(T master) {
        Class<?> entityClass = master.getClass();
        List<SlaveInfo> slaveInfoList = SlaveUtils.getSlaveInfoList(entityClass);
        if (CollectionUtils.isEmpty(slaveInfoList)) {
            return;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(master);
        for (SlaveInfo slaveInfo : slaveInfoList) {
            if (CollectionUtils.isEmpty(slaveInfo.getRefFields())) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String refField : slaveInfo.getRefFields()) {
                params.put(refField, beanWrapper.getPropertyValue(refField));
            }
            List<T> slaveBeanList = this.selectByMap(params, slaveInfo.getSlaveClazz());
            if (CollectionUtils.isEmpty(slaveBeanList)) continue;
            beanWrapper.setPropertyValue(slaveInfo.getFieldName(), slaveBeanList);
        }
    }
}

