/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.mybatis;

import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.mapper.AutoSqlInjector;
import com.baomidou.mybatisplus.toolkit.PluginUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.Map;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.SqlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSqlInjectorPlus
extends AutoSqlInjector {
    private static final Logger log = LoggerFactory.getLogger(AutoSqlInjectorPlus.class);

    public void inject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        this.configuration = builderAssistant.getConfiguration();
        this.builderAssistant = builderAssistant;
        this.languageDriver = this.configuration.getDefaultScriptingLanguageInstance();
        Class modelClass = this.extractModelClass(mapperClass);
        TableInfo table = null;
        if (null != modelClass) {
            if (this.getGlobalConfig().isSqlParserCache()) {
                PluginUtils.initSqlParserInfoCache(mapperClass);
            }
            table = TableInfoHelper.initTableInfo((MapperBuilderAssistant)builderAssistant, (Class)modelClass);
            this.injectSql(builderAssistant, mapperClass, modelClass, table);
        }
        this.injectSelectSqlSql(mapperClass, modelClass, table);
        this.injectSelectSqlMapSql(mapperClass, modelClass, table);
        this.injectSelectSqlMapByMapSql(mapperClass, modelClass, table);
        this.injectInsertSqlSql(mapperClass, modelClass, table);
        this.injectUpdateSqlSql(mapperClass, modelClass, table);
        this.injectDeleteSqlSql(mapperClass, modelClass, table);
    }

    private void injectSelectSqlSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = "${value}";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, "selectSql", sqlSource, modelClass, table);
    }

    private void injectSelectSqlMapSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = "${value}";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, "selectSqlMap", sqlSource, Map.class, table);
    }

    private void injectSelectSqlMapByMapSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = "${sql}";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Map.class);
        this.addSelectMappedStatement(mapperClass, "selectSqlMapByMap", sqlSource, Map.class, table);
    }

    private void injectInsertSqlSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = "${value}";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addInsertMappedStatement(mapperClass, modelClass, "insertSql", sqlSource, (KeyGenerator)new NoKeyGenerator(), table.getKeyProperty(), table.getKeyColumn());
    }

    private void injectUpdateSqlSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = "${value}";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addUpdateMappedStatement(mapperClass, modelClass, "updateSql", sqlSource);
    }

    private void injectDeleteSqlSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = "${value}";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addDeleteMappedStatement(mapperClass, "deleteSql", sqlSource);
    }
}

