/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.permission.impl;

import com.efuture.msboot.core.bean.SimpleBeanUtils;
import com.efuture.msboot.data.permission.PermissionDefineService;
import com.efuture.msboot.data.permission.beans.PermissionColumnDefine;
import com.efuture.msboot.data.permission.beans.PermissionTableDefine;
import com.efuture.msboot.data.permission.config.YamlPermissionConfigurationProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class YmlPermissionDefineServiceImpl
implements PermissionDefineService {
    @Autowired
    YamlPermissionConfigurationProperties yamlPermissionConfigurationProperties;
    private Map<String, PermissionTableDefine> tableDefineMap;

    @PostConstruct
    public void init() {
        this.buildMap();
    }

    @Override
    public Set<String> getTables() {
        return this.tableDefineMap.keySet();
    }

    @Override
    public PermissionTableDefine getTableDefine(String tablename) {
        Assert.hasText((String)tablename, (String)"tablename \u4e0d\u80fd\u4e3a\u7a7a");
        return this.tableDefineMap.get(tablename.toLowerCase());
    }

    private void buildMap() {
        this.tableDefineMap = new HashMap<String, PermissionTableDefine>();
        if (!CollectionUtils.isEmpty(this.yamlPermissionConfigurationProperties.getTables())) {
            this.yamlPermissionConfigurationProperties.getTables().forEach((key, value) -> {
                String tablename = key.toLowerCase();
                PermissionTableDefine permissionTableDefine = new PermissionTableDefine();
                permissionTableDefine.setTablename(tablename);
                if (!CollectionUtils.isEmpty(value.getColumn())) {
                    permissionTableDefine.setPermissionColumnDefineList(SimpleBeanUtils.convertBeanList(value.getColumn(), PermissionColumnDefine.class));
                }
                this.tableDefineMap.put(tablename, permissionTableDefine);
            });
        }
        if (!CollectionUtils.isEmpty(this.yamlPermissionConfigurationProperties.getColumns())) {
            this.yamlPermissionConfigurationProperties.getColumns().forEach((key, value) -> {
                String[] tables;
                Assert.hasText((String)value.getTables(), (String)"\u5c5e\u6027 tables \u4e0d\u80fd\u4e3a\u7a7a");
                String column = key.toLowerCase();
                for (String tablename : tables = value.getTables().split(",")) {
                    boolean exist;
                    PermissionTableDefine permissionTableDefine = this.tableDefineMap.get(tablename);
                    if (permissionTableDefine == null) {
                        permissionTableDefine = new PermissionTableDefine();
                        permissionTableDefine.setTablename(tablename);
                        this.tableDefineMap.put(tablename, permissionTableDefine);
                    }
                    if (CollectionUtils.isEmpty(permissionTableDefine.getPermissionColumnDefineList())) {
                        permissionTableDefine.setPermissionColumnDefineList(new ArrayList<PermissionColumnDefine>());
                    }
                    if (exist = permissionTableDefine.getPermissionColumnDefineList().stream().anyMatch(item -> item.getColumn().equalsIgnoreCase(column))) continue;
                    PermissionColumnDefine permissionColumnDefine = new PermissionColumnDefine();
                    permissionColumnDefine.setColumn(column);
                    permissionColumnDefine.setTablename(tablename);
                    permissionColumnDefine.setFilterUpdateOrDelete(value.getFilterUpdateOrDelete());
                    permissionColumnDefine.setRequiretype(value.getRequiretype());
                    permissionColumnDefine.setResourcetype(value.getResourcetype());
                    permissionTableDefine.getPermissionColumnDefineList().add(permissionColumnDefine);
                }
            });
        }
    }
}

