/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.permission.parser;

import com.baomidou.mybatisplus.plugins.parser.AbstractJsqlParser;
import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.permission.PermissionDefineService;
import com.efuture.msboot.data.permission.PermissionResourceService;
import com.efuture.msboot.data.permission.beans.PermissionColumnDefine;
import com.efuture.msboot.data.permission.beans.PermissionTableDefine;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ResourceSqlParser
extends AbstractJsqlParser {
    private static final Logger log = LoggerFactory.getLogger(ResourceSqlParser.class);
    @Autowired
    private PermissionDefineService permissionDefineService;
    @Autowired
    private PermissionResourceService permissionResourceService;

    public void processInsert(Insert insert) {
    }

    public void processDelete(Delete delete) {
        if (this.isEmptySession()) {
            return;
        }
        Table table = delete.getTable();
        if (this.doTableFilter(table.getName())) {
            return;
        }
        delete.setWhere(this.buildUpdateOrDeleteExpression(delete.getWhere(), table));
    }

    public void processUpdate(Update update) {
        if (this.isEmptySession()) {
            return;
        }
        List tableList = update.getTables();
        if (null == tableList || tableList.size() >= 2) {
            log.warn("unsupport process multiple-table update, please exclude the statementId");
            return;
        }
        Table table = (Table)tableList.get(0);
        if (this.doTableFilter(table.getName())) {
            return;
        }
        update.setWhere(this.buildUpdateOrDeleteExpression(update.getWhere(), table));
    }

    public void processSelectBody(SelectBody selectBody) {
        if (this.isEmptySession()) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect);
                }
            }
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        this.processPlainSelect(plainSelect, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (this.doTableFilter(fromTable.getName())) {
                return;
            }
            plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
            if (!addColumn) {
                // empty if block
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            for (Join join : joins) {
                this.processJoin(join);
                this.processFromItem(join.getRightItem());
            }
        }
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoin() != null) {
                this.processJoin(subJoin.getJoin());
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        if (join.getRightItem() instanceof Table) {
            Table fromTable = (Table)join.getRightItem();
            if (this.doTableFilter(fromTable.getName())) {
                return;
            }
            join.setOnExpression(this.builderExpression(join.getOnExpression(), fromTable));
        }
    }

    protected Expression builderExpression(Expression expression, Table table) {
        PermissionTableDefine permissionTableDefine = this.permissionDefineService.getTableDefine(table.getName().toLowerCase());
        Expression okExp = null;
        for (PermissionColumnDefine permissionColumnDefine : permissionTableDefine.getPermissionColumnDefineList()) {
            if (okExp == null) {
                okExp = this.makeInExpression(permissionColumnDefine, table);
                continue;
            }
            okExp = new AndExpression(okExp, this.makeInExpression(permissionColumnDefine, table));
        }
        if (expression == null) {
            return okExp;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getLeftExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getLeftExpression());
            }
            if (binaryExpression.getRightExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getRightExpression());
            }
        }
        return new AndExpression(okExp, expression);
    }

    protected Expression buildUpdateOrDeleteExpression(Expression expression, Table table) {
        PermissionTableDefine permissionTableDefine = this.permissionDefineService.getTableDefine(table.getName().toLowerCase());
        Expression okExp = null;
        for (PermissionColumnDefine permissionColumnDefine : permissionTableDefine.getPermissionColumnDefineList()) {
            if (!permissionColumnDefine.getFilterUpdateOrDelete().booleanValue()) continue;
            if (okExp == null) {
                okExp = this.makeInExpression(permissionColumnDefine, table);
                continue;
            }
            okExp = new AndExpression(okExp, this.makeInExpression(permissionColumnDefine, table));
        }
        if (okExp == null) {
            return expression;
        }
        if (expression == null) {
            return okExp;
        }
        return new AndExpression(okExp, expression);
    }

    protected Column getAliasColumn(Table table, String columnname) {
        if (null == table.getAlias()) {
            return new Column(columnname);
        }
        StringBuilder column = new StringBuilder();
        column.append(table.getAlias().getName());
        column.append(".");
        column.append(columnname);
        return new Column(column.toString());
    }

    private ExpressionList getExpressionList(PermissionColumnDefine permissionColumnDefine) {
        Set<String> resourceCodeSet = this.permissionResourceService.getResourceCodeSet(permissionColumnDefine.getResourcetype());
        if (CollectionUtils.isEmpty(resourceCodeSet)) {
            if ("require_throws".equalsIgnoreCase(permissionColumnDefine.getRequiretype())) {
                ExceptionUtils.raise((String)MessageFormat.format("{0}-{1} \u627e\u4e0d\u5230\u8d44\u6e90 \u3010{2}\u3011", permissionColumnDefine.getTablename(), permissionColumnDefine.getColumn(), permissionColumnDefine.getResourcetype()));
            }
            resourceCodeSet = new HashSet<String>();
            resourceCodeSet.add("null_resource");
        }
        ExpressionList expressionList = new ExpressionList();
        ArrayList<StringValue> expList = new ArrayList<StringValue>();
        for (String code : resourceCodeSet) {
            expList.add(new StringValue(code));
        }
        expressionList.setExpressions(expList);
        return expressionList;
    }

    private Expression makeInExpression(PermissionColumnDefine permissionColumnDefine, Table table) {
        MultiExpressionList multiExpressionList = new MultiExpressionList();
        multiExpressionList.addExpressionList(this.getExpressionList(permissionColumnDefine));
        InExpression equalsTo = new InExpression();
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table, permissionColumnDefine.getColumn()));
        equalsTo.setRightItemsList((ItemsList)multiExpressionList);
        return equalsTo;
    }

    private boolean doTableFilter(String tablename) {
        return !this.permissionDefineService.getTables().contains(tablename.toLowerCase());
    }

    private boolean isEmptySession() {
        SessionContext sessionContext = SessionContextHolder.get();
        if (sessionContext == null) {
            return true;
        }
        return sessionContext.getUserId() == null && sessionContext.getUserCode() == null && sessionContext.getUserName() == null;
    }
}

