/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.query.impl;

import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.bean.EntityDBInfo;
import com.efuture.msboot.data.bean.ViewInfo;
import com.efuture.msboot.data.query.SqlBuilder;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.data.utils.EntityDBInfoUtils;
import com.efuture.msboot.data.utils.ViewUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultSqlBuilder
implements SqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultSqlBuilder.class);

    @Override
    public String buildConditionSqlTemplate(Map<String, Object> columnMap) {
        if (CollectionUtils.isEmpty(columnMap)) {
            return "";
        }
        StringBuilder condition = new StringBuilder();
        int idx = 0;
        int size = columnMap.size();
        for (Map.Entry<String, Object> entry : columnMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value != null && value.toString().contains("%")) {
                condition.append(key + " like #{" + key + "}");
            } else {
                condition.append(key + " = #{" + key + "}");
            }
            if (idx != size - 1) {
                condition.append(" and ");
            }
            ++idx;
        }
        return condition.toString();
    }

    @Override
    public String buildSqlTemplate(SearchInfo searchInfo) {
        Assert.notNull((Object)searchInfo.getEntityClazz());
        this.adapterSearchCondition(searchInfo);
        this.checkSearchCondition(searchInfo);
        this.preSearchCondtion(searchInfo);
        boolean isView = ViewUtils.isView(searchInfo.getEntityClazz());
        if (isView) {
            return this.buildSqlTemplateView(searchInfo);
        }
        return this.buildSqlTemplateNotView(searchInfo);
    }

    @Override
    public String buildSql(SearchInfo searchInfo) {
        return null;
    }

    private void adapterSearchCondition(SearchInfo searchInfo) {
        if (searchInfo == null || !StringUtils.hasText((String)searchInfo.getCondition())) {
            return;
        }
        searchInfo.setCondition(searchInfo.getCondition().replace("'${", "#{").replace("}'", "}"));
    }

    private void checkSearchCondition(SearchInfo searchInfo) {
        if (searchInfo == null || !StringUtils.hasText((String)searchInfo.getCondition())) {
            return;
        }
        String condition = searchInfo.getCondition().toLowerCase();
        if (condition.contains("--") || condition.contains("insert") || condition.contains("update") || condition.contains("delete") || condition.contains("drop") || condition.contains("truncate") || condition.contains(";")) {
            ExceptionUtils.raise((String)"error conditoin");
        }
    }

    private void preSearchCondtion(SearchInfo searchInfo) {
        if (searchInfo == null || StringUtils.hasText((String)searchInfo.getCondition())) {
            return;
        }
        if (CollectionUtils.isEmpty(searchInfo.getParams())) {
            return;
        }
        searchInfo.setCondition(this.buildConditionSqlTemplate(searchInfo.getParams()));
    }

    private String buildSqlTemplateNotView(SearchInfo searchInfo) {
        Class entityClass = searchInfo.getEntityClazz();
        EntityDBInfo entityDBInfo = EntityDBInfoUtils.getEntityDBInfo(entityClass);
        String conditionSql = searchInfo.getCondition();
        String orderBy = searchInfo.getOrderBy();
        StringBuilder sql = new StringBuilder();
        sql.append(entityDBInfo.getSql());
        if (StringUtils.hasText((String)conditionSql)) {
            String targetCondition = EntityDBInfoUtils.buildConditionSql(entityClass, conditionSql);
            sql.append(" where ");
            sql.append(targetCondition);
        }
        if (StringUtils.hasText((String)searchInfo.getOrderBy())) {
            String targetOrderBy = EntityDBInfoUtils.buildOrderBySql(entityClass, orderBy);
            sql.append(" order by ");
            sql.append(targetOrderBy);
        }
        return sql.toString();
    }

    private String buildSqlTemplateView(SearchInfo searchInfo) {
        Class viewClass = searchInfo.getEntityClazz();
        String conditionSql = searchInfo.getCondition();
        String orderBy = searchInfo.getOrderBy();
        ViewInfo viewInfo = ViewUtils.getViewInfo(searchInfo.getEntityClazz());
        StringBuilder sql = new StringBuilder();
        sql.append(viewInfo.getSql());
        if (StringUtils.hasText((String)conditionSql)) {
            String targetCondition = ViewUtils.buildConditionSql(viewClass, searchInfo.getCondition());
            log.info(">> conditionSql:{} , targetCondition:{}", (Object)conditionSql, (Object)targetCondition);
            sql.append(" where ");
            sql.append(targetCondition);
        }
        if (StringUtils.hasText((String)orderBy)) {
            String targetOrderBy = ViewUtils.buildOrderBySql(viewClass, searchInfo.getOrderBy());
            log.info(">> orderBySql:{} , targetOrderBySql:{}", (Object)orderBy, (Object)targetOrderBy);
            sql.append(" order by ");
            sql.append(targetOrderBy);
        }
        return sql.toString();
    }

    protected Set<String> getConditionFields(SearchInfo searchInfo) {
        return searchInfo.getParams().keySet();
    }
}

