/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.query.impl;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.baomidou.mybatisplus.annotations.TableName;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.annotation.View;
import com.efuture.msboot.data.query.QueryBuilder;
import com.efuture.msboot.data.query.bean.SearchConfig;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.data.query.bean.SearchRef;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SqlQueryBuilder
implements QueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SqlQueryBuilder.class);
    private Set<String> dateField = new HashSet<String>(Arrays.asList("editdate", "checkdate", "begindate", "enddate", "executetime"));

    @Override
    public String buildSql(SearchInfo searchInfo) {
        SearchConfig searchConfig = new SearchConfig();
        searchConfig.setDateField(this.dateField);
        return this.buildSql(searchInfo, searchConfig);
    }

    @Override
    public String buildSql(SearchInfo searchInfo, SearchConfig searchConfig) {
        String orderBy;
        this.preSearchCondtion(searchInfo);
        String masterTable = SqlQueryBuilder.fetchAnnotationTableName(this.getEntryClazz(searchInfo.getEntry()));
        String masterAlias = CollectionUtils.isEmpty(searchInfo.getRefs()) ? "" : "a";
        String masterConditionSql = this.buildConditionSql(searchInfo.getCondition(), searchInfo.getParams(), masterAlias, searchConfig);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        stringBuilder.append(StringUtils.hasText((String)masterAlias) ? masterAlias + "." : "");
        stringBuilder.append("* from " + masterTable + " ");
        stringBuilder.append(StringUtils.hasText((String)masterAlias) ? masterAlias : "");
        stringBuilder.append(" ");
        StringBuilder innerSqlBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty(searchInfo.getRefs())) {
            int idx = 1;
            for (SearchRef searchRef : searchInfo.getRefs()) {
                String refAlias = "b" + idx;
                Class refClazz = this.getEntryClazz(searchRef.getEntry());
                if (!StringUtils.hasText((String)searchRef.getRefFields())) {
                    ExceptionUtils.raise((String)"\u672a\u914d\u7f6e refFields");
                }
                String refTable = SqlQueryBuilder.fetchAnnotationTableName(refClazz);
                String[] refFields = searchRef.getRefFields().split(",");
                String innerSql = "";
                int i = 0;
                for (String refField : refFields) {
                    innerSql = innerSql + "a." + refField + "=" + refAlias + "." + refField + " ";
                    innerSql = innerSql + (i != refFields.length - 1 ? " and " : "");
                    ++i;
                }
                innerSqlBuilder.append("inner join " + refTable + " " + refAlias + " on " + innerSql);
                SearchInfo si = new SearchInfo();
                si.setCondition(searchRef.getCondition());
                si.setParams(searchRef.getParams());
                String refSql = this.buildConditionSql(si.getCondition(), si.getParams(), refAlias, searchConfig);
                innerSqlBuilder.append(" and " + refSql);
                ++idx;
            }
        }
        stringBuilder.append((CharSequence)innerSqlBuilder);
        if (StringUtils.hasText((String)masterConditionSql)) {
            stringBuilder.append(" where ");
            stringBuilder.append(masterConditionSql);
        }
        if (StringUtils.hasText((String)(orderBy = searchInfo.getOrderBy()))) {
            StringBuilder orderBySqlBuilder = new StringBuilder();
            orderBySqlBuilder.append(" order by ");
            if (StringUtils.hasText((String)masterAlias)) {
                Set<String> orderByColumns = this.getOrderByColumns(orderBy);
                String targetOrderBy = orderBy;
                for (String column : orderByColumns) {
                    targetOrderBy = targetOrderBy.replace(column, masterAlias + "." + column);
                }
                orderBySqlBuilder.append(targetOrderBy);
            } else {
                orderBySqlBuilder.append(orderBy);
            }
            stringBuilder.append((CharSequence)orderBySqlBuilder);
        }
        String fSql = SQLUtils.format((String)stringBuilder.toString(), (String)"mysql");
        return fSql;
    }

    @Override
    public String buildSql(Class viewClazz) {
        View view = viewClazz.getAnnotation(View.class);
        if (view == null) {
            ExceptionUtils.raise((String)"\u672a\u4f7f\u7528 @View \u6ce8\u89e3");
        }
        return null;
    }

    @Override
    public String buildSql(SearchInfo searchInfo, Class voClazz) {
        return null;
    }

    @Override
    public String buildConditionSql(String alias, SearchInfo searchInfo) {
        this.preSearchCondtion(searchInfo);
        String condition = searchInfo.getCondition();
        Map<String, Object> params = searchInfo.getParams();
        if (!StringUtils.hasText((String)condition) && CollectionUtils.isEmpty(params)) {
            return "";
        }
        this.checkCondition(condition);
        String realCondition = condition;
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> keyValue : params.entrySet()) {
                String key = keyValue.getKey();
                Object value = keyValue.getValue();
                String strValue = "";
                strValue = value instanceof String ? "'" + String.valueOf(value) + "'" : String.valueOf(value);
                realCondition = realCondition.replace("'${" + key + "}'", strValue);
            }
        }
        Set<String> conditionColumns = this.getConditionColumns(condition);
        for (String column : conditionColumns) {
            String funField;
            if (!column.equalsIgnoreCase(funField = this.makeFunField(column, new SearchConfig()))) {
                realCondition = realCondition.replace(column, funField);
            }
            if (!StringUtils.hasText((String)alias) || realCondition.contains("." + column)) continue;
            realCondition = realCondition.replace(column, alias + "." + column);
        }
        return realCondition;
    }

    private void preSearchCondtion(SearchInfo searchInfo) {
        if (searchInfo == null || StringUtils.hasText((String)searchInfo.getCondition())) {
            return;
        }
        if (CollectionUtils.isEmpty(searchInfo.getParams())) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        Iterator<String> iterator = searchInfo.getParams().keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = searchInfo.getParams().get(key);
            if (value != null && (value.toString().startsWith("%") || value.toString().endsWith("%"))) {
                sql.append("" + key + " like '${" + key + "}'");
            } else {
                sql.append("" + key + "='${" + key + "}'");
            }
            if (!iterator.hasNext()) continue;
            sql.append(" and ");
        }
        log.info(">> pre searchInfo: {} - condition: {}", (Object)searchInfo, (Object)sql);
        searchInfo.setCondition(sql.toString());
    }

    public static String fetchAnnotationTableName(Class<?> cl) {
        Annotation[] annos;
        for (Annotation ann : annos = cl.getAnnotations()) {
            if (!(ann instanceof TableName)) continue;
            return ((TableName)ann).value();
        }
        String name = cl.getName();
        return (name = name.substring(name.lastIndexOf(".") + 1).toLowerCase()).endsWith("bean") ? name.substring(0, name.length() - 4) : name;
    }

    private String buildConditionSql(String condition, Map<String, Object> params, String alias, SearchConfig searchConfig) {
        if (!StringUtils.hasText((String)condition)) {
            return "";
        }
        this.checkCondition(condition);
        String realCondition = condition;
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> keyValue : params.entrySet()) {
                String key = keyValue.getKey();
                Object value = keyValue.getValue();
                String strValue = "";
                strValue = value instanceof String ? "'" + String.valueOf(value) + "'" : String.valueOf(value);
                realCondition = realCondition.replace("'${" + key + "}'", strValue);
            }
        }
        Set<String> conditionColumns = this.getConditionColumns(condition);
        for (String column : conditionColumns) {
            String funField;
            if (!column.equalsIgnoreCase(funField = this.makeFunField(column, searchConfig))) {
                realCondition = realCondition.replace(column, funField);
            }
            if (!StringUtils.hasText((String)alias)) continue;
            realCondition = realCondition.replace(column, alias + "." + column);
        }
        return realCondition;
    }

    private String makeFunField(String column, SearchConfig searchConfig) {
        String result = column;
        if (!CollectionUtils.isEmpty(searchConfig.getDateField())) {
            for (String df : searchConfig.getDateField()) {
                if (!column.equalsIgnoreCase(df)) continue;
                result = "date(" + df + ")";
                break;
            }
        }
        return result;
    }

    private Class getEntryClazz(String entry) {
        try {
            return Class.forName(entry);
        }
        catch (Exception e) {
            ExceptionUtils.raise((String)e.getMessage());
            return null;
        }
    }

    protected Set<String> getConditionColumns(String condition) {
        if (!StringUtils.hasText((String)condition)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> columns = new HashSet<String>();
        String sql = "select * from efuture where " + condition;
        String dbType = "mysql";
        SQLStatement stmt = (SQLStatement)SQLUtils.parseStatements((String)sql, (String)dbType).get(0);
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        stmt.accept((SQLASTVisitor)visitor);
        for (TableStat.Condition cond : visitor.getConditions()) {
            String txt = cond.getColumn().toString();
            if (txt.contains(".")) {
                columns.add(cond.getColumn().toString().split("\\.")[1]);
                continue;
            }
            columns.add(cond.getColumn().toString());
        }
        return columns;
    }

    protected Set<String> getOrderByColumns(String orderBy) {
        if (!StringUtils.hasText((String)orderBy)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> columns = new HashSet<String>();
        String sql = "select * from efuture order by " + orderBy;
        String dbType = "mysql";
        SQLStatement stmt = (SQLStatement)SQLUtils.parseStatements((String)sql, (String)dbType).get(0);
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        stmt.accept((SQLASTVisitor)visitor);
        for (TableStat.Column column : visitor.getOrderByColumns()) {
            String txt = column.toString();
            if (txt.contains(".")) {
                columns.add(txt.split("\\.")[1]);
                continue;
            }
            columns.add(txt.toString());
        }
        return columns;
    }

    private void checkCondition(String condition) {
        String test = condition.toLowerCase();
        if (test.contains("where") || test.contains("select") || test.contains("insert") || test.contains("update") || test.contains("delete") || test.contains("--")) {
            ExceptionUtils.raise((String)("\u975e\u6cd5condition: " + condition));
        }
    }

    public Set<String> getDateField() {
        return this.dateField;
    }

    public void setDateField(Set<String> dateField) {
        this.dateField = dateField;
    }
}

