/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.utils;

import com.baomidou.mybatisplus.annotations.TableField;
import com.efuture.msboot.core.reflect.utils.ReflectUtils;
import com.efuture.msboot.data.annotation.Slave;
import com.efuture.msboot.data.bean.EntityDBInfo;
import com.efuture.msboot.data.utils.EntityUtils;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EntityDBInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityDBInfoUtils.class);
    public static Map<String, EntityDBInfo> entityInfoCache = new HashMap<String, EntityDBInfo>();

    public static EntityDBInfo getEntityDBInfo(Class clazz) {
        Assert.notNull((Object)clazz, (String)"clazz is null");
        String key = clazz.getName();
        if (entityInfoCache.containsKey(key)) {
            return entityInfoCache.get(key);
        }
        EntityDBInfo entityDBInfo = new EntityDBInfo();
        entityDBInfo.setClazz(clazz);
        entityDBInfo.setTable(EntityUtils.fetchAnnotationTableName(clazz));
        StringBuilder select = new StringBuilder();
        List fields = ReflectUtils.getAllFields((Class)clazz);
        int length = fields.size();
        if (length == 0) {
            select.append(" * ");
        }
        for (Field field : fields) {
            TableField tableField;
            String fieldName = field.getName();
            if (field.getAnnotation(Slave.class) != null || (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) continue;
            if (tableField != null && StringUtils.hasText((String)tableField.value())) {
                select.append("" + tableField.value() + " as " + fieldName);
                entityDBInfo.getFieldColumnMap().put(fieldName, tableField.value());
            } else {
                select.append(fieldName);
            }
            entityDBInfo.getSelectFieldList().add(fieldName);
            select.append(",");
        }
        if (select.length() > 0) {
            select.deleteCharAt(select.length() - 1);
        }
        String sql = MessageFormat.format("select {0} from {1}", select, entityDBInfo.getTable());
        entityDBInfo.setSql(sql);
        entityInfoCache.put(key, entityDBInfo);
        return entityDBInfo;
    }

    public static String buildConditionSql(Class clazz, String condition) {
        if (!StringUtils.hasText((String)condition)) {
            return "";
        }
        EntityDBInfo entityDBInfo = EntityDBInfoUtils.getEntityDBInfo(clazz);
        String targetCondition = condition;
        for (String field : entityDBInfo.getSelectFieldList()) {
            if (targetCondition.contains("." + field)) continue;
            String column = field;
            if (entityDBInfo.getFieldColumnMap().containsKey(field)) {
                column = entityDBInfo.getFieldColumnMap().get(field);
            }
            targetCondition = targetCondition.replaceAll("\\b" + field + "\\s", column + " ");
        }
        return targetCondition;
    }

    public static String buildOrderBySql(Class viewClass, String orderBy) {
        if (!StringUtils.hasText((String)orderBy)) {
            return "";
        }
        EntityDBInfo entityDBInfo = EntityDBInfoUtils.getEntityDBInfo(viewClass);
        String targetOrderBy = orderBy;
        Iterator<String> iterator = entityDBInfo.getSelectFieldList().iterator();
        while (iterator.hasNext()) {
            String field;
            String column = field = iterator.next();
            if (entityDBInfo.getFieldColumnMap().containsKey(field)) {
                column = entityDBInfo.getFieldColumnMap().get(field);
            }
            targetOrderBy = targetOrderBy.replaceAll("\\b" + field + "\\b", "" + column + " ");
        }
        return targetOrderBy;
    }
}

