/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.utils;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.map.StringObjectMap;
import com.efuture.msboot.core.reflect.utils.ReflectUtils;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.core.utils.SpringContextHolder;
import com.efuture.msboot.data.annotation.TablePrimaryKey;
import com.efuture.msboot.data.bean.CURDEnum;
import com.efuture.msboot.data.entity.EntityInitializer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EntityUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityUtils.class);
    public static Map<String, String> idInfoCache = new HashMap<String, String>();

    public static String getIdField(Class clazz) {
        String key = clazz.getName();
        if (idInfoCache.containsKey(key)) {
            return idInfoCache.get(key);
        }
        boolean isFieldNameId = false;
        for (Field field : ReflectUtils.getAllFields((Class)clazz)) {
            boolean isTableId;
            if (field.getName().equals("id")) {
                isFieldNameId = true;
            }
            if (!(isTableId = field.isAnnotationPresent(TableId.class))) continue;
            String idField = field.getName();
            TableId tableId = field.getAnnotation(TableId.class);
            if (StringUtils.hasText((String)tableId.value())) {
                idField = tableId.value();
            }
            idInfoCache.put(key, idField);
        }
        if (idInfoCache.containsKey(key)) {
            return idInfoCache.get(key);
        }
        if (isFieldNameId) {
            idInfoCache.put(key, "id");
            return idInfoCache.get(key);
        }
        return null;
    }

    public static Serializable getIdValue(Object entity) {
        Assert.notNull((Object)entity, (String)"entity is null");
        String idField = EntityUtils.getIdField(entity.getClass());
        if (StringUtils.hasText((String)idField)) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
            return (Serializable)beanWrapper.getPropertyValue(idField);
        }
        if (EntityUtils.hasTablePrimaryKey(entity.getClass())) {
            return (Serializable)entity;
        }
        ExceptionUtils.raise((String)"\u6ca1\u6709\u914d\u7f6eid\u5b57\u6bb5");
        return null;
    }

    public static Map<String, Object> getIdValueMap(Object entity) {
        Assert.notNull((Object)entity, (String)"entity is null");
        String idField = EntityUtils.getIdField(entity.getClass());
        if (StringUtils.hasText((String)idField)) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
            return StringObjectMap.create((Object[])new Object[]{idField, beanWrapper.getPropertyValue(idField)});
        }
        if (EntityUtils.hasTablePrimaryKey(entity.getClass())) {
            Class<?> clazz = entity.getClass();
            TablePrimaryKey tablePrimaryKey = clazz.getAnnotation(TablePrimaryKey.class);
            if (tablePrimaryKey.keys().length == 0) {
                ExceptionUtils.raise((String)"\u6ca1\u6709\u914d\u7f6ekeys");
            }
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
            StringObjectMap idValueMap = StringObjectMap.create();
            for (String key : tablePrimaryKey.keys()) {
                idValueMap.put(key, beanWrapper.getPropertyValue(key));
            }
            return idValueMap;
        }
        ExceptionUtils.raise((String)"\u6ca1\u6709\u914d\u7f6eid\u5b57\u6bb5");
        return null;
    }

    public static Boolean hasIdValue(Object entity) {
        Map<String, Object> idValueMap = EntityUtils.getIdValueMap(entity);
        if (CollectionUtils.isEmpty(idValueMap)) {
            return false;
        }
        for (Object value : idValueMap.values()) {
            if (value == null) continue;
            return true;
        }
        return false;
    }

    public static void initInsert(Object entity) {
        EntityInitializer entityInitializer = (EntityInitializer)SpringContextHolder.getBean(EntityInitializer.class);
        entityInitializer.initInsert(entity);
    }

    public static void initUpdate(Object entity) {
        EntityInitializer entityInitializer = (EntityInitializer)SpringContextHolder.getBean(EntityInitializer.class);
        entityInitializer.initUpdate(entity);
    }

    public static boolean hasTablePrimaryKey(Class clazz) {
        TablePrimaryKey tablePrimaryKey = clazz.getAnnotation(TablePrimaryKey.class);
        return tablePrimaryKey != null;
    }

    public static Object getPropertyValue(Object entity, String property) {
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        if (!beanWrapper.getPropertiesSet().contains(property)) {
            return null;
        }
        return beanWrapper.getPropertyValue(property);
    }

    public static void setPropertyValue(Object entity, String property, Object value) {
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        beanWrapper.setPropertyValueIfExist(property, value);
    }

    public static String getCurdFlag(Object entity) {
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        if (beanWrapper.getPropertiesSet().contains("curd_flag")) {
            Object value = beanWrapper.getPropertyValue("curd_flag");
            return value == null ? null : String.valueOf(value);
        }
        Map<String, Object> idValueMap = EntityUtils.getIdValueMap(entity);
        if (idValueMap == null) {
            return null;
        }
        boolean hasIdValue = false;
        for (Object obj : idValueMap.values()) {
            if (obj == null) continue;
            hasIdValue = true;
            break;
        }
        return hasIdValue ? CURDEnum.UPDATE.toString() : CURDEnum.INSERT.toString();
    }

    public static String fetchAnnotationTableName(Class<?> cl) {
        Annotation[] annos;
        for (Annotation ann : annos = cl.getAnnotations()) {
            if (!(ann instanceof TableName)) continue;
            return ((TableName)ann).value();
        }
        String name = cl.getName();
        return (name = name.substring(name.lastIndexOf(".") + 1).toLowerCase()).endsWith("bean") ? name.substring(0, name.length() - 4) : name;
    }
}

