/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.utils;

import com.efuture.msboot.data.annotation.Slave;
import com.efuture.msboot.data.bean.SlaveInfo;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaveUtils {
    private static final Logger log = LoggerFactory.getLogger(SlaveUtils.class);
    public static Map<String, List<SlaveInfo>> slaveInfoCache = new HashMap<String, List<SlaveInfo>>();

    public static List<SlaveInfo> getSlaveInfoList(Class clazz) {
        String key = clazz.getName();
        if (slaveInfoCache.containsKey(key)) {
            return slaveInfoCache.get(key);
        }
        Class masterClazz = clazz;
        ArrayList<SlaveInfo> slaveInfoList = new ArrayList<SlaveInfo>();
        for (Field field : masterClazz.getDeclaredFields()) {
            boolean isSlave = field.isAnnotationPresent(Slave.class);
            if (!isSlave) continue;
            Slave slave = field.getAnnotation(Slave.class);
            Type fieldGenericType = field.getGenericType();
            if (fieldGenericType == null) {
                log.warn(">>\u672a\u627e\u5230\u6cdb\u578b\u7684\u7c7b\u578b ");
                continue;
            }
            Type[] types = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
            Class slaveClazz = (Class)types[0];
            SlaveInfo slaveInfo = new SlaveInfo();
            slaveInfo.setField(field);
            slaveInfo.setFieldName(field.getName());
            slaveInfo.setRefFields(Arrays.asList(slave.refFields()));
            slaveInfo.setSlaveClazz(slaveClazz);
            slaveInfo.setInsertAllowEmpty(slave.insertAllowEmpty());
            slaveInfoList.add(slaveInfo);
        }
        slaveInfoCache.put(key, slaveInfoList);
        return slaveInfoList;
    }
}

