/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.data.utils;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.baomidou.mybatisplus.annotations.TableField;
import com.efuture.msboot.core.reflect.utils.ReflectUtils;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.annotation.JoinTableField;
import com.efuture.msboot.data.annotation.Slave;
import com.efuture.msboot.data.annotation.View;
import com.efuture.msboot.data.bean.JoinTableInfo;
import com.efuture.msboot.data.bean.ViewInfo;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ViewUtils {
    private static final Logger log = LoggerFactory.getLogger(ViewUtils.class);
    public static Map<String, ViewInfo> viewInfoCache = new HashMap<String, ViewInfo>();

    public static Boolean isView(Class clazz) {
        return clazz.getAnnotation(View.class) != null;
    }

    public static ViewInfo getViewInfo(Class clazz) {
        String key = clazz.getName();
        if (viewInfoCache.containsKey(key)) {
            return viewInfoCache.get(key);
        }
        Class masterClazz = clazz;
        View view = clazz.getAnnotation(View.class);
        if (view == null) {
            ExceptionUtils.raise((String)"\u672a\u4f7f\u7528 @View \u6ce8\u89e3");
        }
        String[] joinTables = view.joinTables();
        ArrayList<String> joinExprList = new ArrayList<String>();
        ViewInfo viewInfo = new ViewInfo();
        viewInfo.setMasterTable(view.master());
        viewInfo.setJoinTableInfoMap(new HashMap<String, JoinTableInfo>());
        int idx = 1;
        for (String joinTable : joinTables) {
            String joinExpr = "";
            if (joinTable.contains("join")) {
                joinExpr = joinTable;
            } else {
                String alias = "j" + idx;
                joinExpr = MessageFormat.format(" inner join {0} {1} on m.{0}id = {1}.{0}id", joinTable, alias);
            }
            JoinTableInfo joinTableInfo = ViewUtils.getJoinTableInfo(joinExpr);
            viewInfo.getJoinTableInfoMap().put(joinTableInfo.getTableName(), joinTableInfo);
            joinExprList.add(joinExpr);
            ++idx;
        }
        StringBuilder select = new StringBuilder();
        List fields = ReflectUtils.getAllFields((Class)masterClazz);
        int length = fields.size();
        for (int i = 0; i < length; ++i) {
            Field field = (Field)fields.get(i);
            String fieldName = field.getName();
            boolean isJoin = field.isAnnotationPresent(JoinTableField.class);
            if (isJoin) {
                JoinTableField join = field.getAnnotation(JoinTableField.class);
                String tableName = join.value();
                String column = join.column();
                if (!StringUtils.hasText((String)tableName)) {
                    tableName = join.tableName();
                }
                if (!StringUtils.hasText((String)tableName)) {
                    ExceptionUtils.raise((String)"table name undefine");
                }
                JoinTableInfo joinTableInfo = viewInfo.getJoinTableInfoMap().get(tableName);
                String alias = joinTableInfo.getAlias();
                if (StringUtils.hasText((String)column)) {
                    select.append(alias + "." + column + " as " + fieldName);
                    joinTableInfo.getFieldColumnMap().put(fieldName, column);
                } else {
                    select.append(alias + "." + fieldName);
                }
                joinTableInfo.getSelectFieldList().add(fieldName);
            } else {
                TableField tableField;
                if (field.getAnnotation(Slave.class) != null || (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) continue;
                if (tableField != null && StringUtils.hasText((String)tableField.value())) {
                    select.append("m." + tableField.value() + " as " + fieldName);
                    viewInfo.getFieldColumnMap().put(fieldName, tableField.value());
                } else {
                    select.append("m." + fieldName);
                }
                viewInfo.getSelectFieldList().add(fieldName);
            }
            select.append(",");
        }
        if (select.length() > 0) {
            select.deleteCharAt(select.length() - 1);
        }
        StringBuilder innerSql = new StringBuilder();
        joinExprList.forEach(item -> {
            innerSql.append((String)item);
            innerSql.append(" ");
        });
        String sql = MessageFormat.format("select {0} from {1} m {2}", select, view.master(), innerSql);
        viewInfo.setSql(sql);
        viewInfoCache.put(key, viewInfo);
        return viewInfo;
    }

    public static String buildOrderBySql(Class viewClass, String orderBy) {
        if (!StringUtils.hasText((String)orderBy)) {
            return "";
        }
        ViewInfo viewInfo = ViewUtils.getViewInfo(viewClass);
        String targetOrderBy = orderBy.toLowerCase();
        for (String field : viewInfo.getSelectFieldList()) {
            if (targetOrderBy.contains("." + field)) continue;
            String column = field;
            if (viewInfo.getFieldColumnMap().containsKey(field)) {
                column = viewInfo.getFieldColumnMap().get(field);
            }
            targetOrderBy = targetOrderBy.replaceAll("\\b" + field + "\\b", viewInfo.getMasterAlias() + "." + column + " ");
        }
        for (JoinTableInfo joinTableInfo : viewInfo.getJoinTableInfoMap().values()) {
            for (String field : joinTableInfo.getSelectFieldList()) {
                if (targetOrderBy.contains("." + field + " ")) continue;
                String column = field;
                if (joinTableInfo.getFieldColumnMap().containsKey(field)) {
                    column = joinTableInfo.getFieldColumnMap().get(field);
                }
                targetOrderBy = targetOrderBy.replaceAll("\\b" + field + "\\b", joinTableInfo.getAlias() + "." + column);
            }
        }
        return targetOrderBy;
    }

    public static String buildConditionSql(Class viewClass, String condition) {
        if (!StringUtils.hasText((String)condition)) {
            return "";
        }
        ViewInfo viewInfo = ViewUtils.getViewInfo(viewClass);
        String targetCondition = condition;
        for (String field : viewInfo.getSelectFieldList()) {
            if (targetCondition.contains("." + field)) continue;
            String column = field;
            if (viewInfo.getFieldColumnMap().containsKey(field)) {
                column = viewInfo.getFieldColumnMap().get(field);
            }
            targetCondition = targetCondition.replaceAll("\\b" + field + "\\s", viewInfo.getMasterAlias() + "." + column + " ");
        }
        for (JoinTableInfo joinTableInfo : viewInfo.getJoinTableInfoMap().values()) {
            for (String field : joinTableInfo.getSelectFieldList()) {
                if (targetCondition.contains("." + field)) continue;
                String column = field;
                if (joinTableInfo.getFieldColumnMap().containsKey(field)) {
                    column = joinTableInfo.getFieldColumnMap().get(field);
                }
                targetCondition = targetCondition.replaceAll("\\b" + field + "\\s", joinTableInfo.getAlias() + "." + column + " ");
            }
        }
        return targetCondition;
    }

    public static JoinTableInfo getJoinTableInfo(String joinExpr) {
        String sql = "select m.* from efuture m " + joinExpr;
        SQLStatement stmt = (SQLStatement)SQLUtils.parseStatements((String)sql, (String)"mysql").get(0);
        SQLTableSource from = ((MySqlSelectQueryBlock)((SQLSelectStatement)stmt).getSelect().getQuery()).getFrom();
        SQLTableSource joinTable = ((SQLJoinTableSource)from).getRight();
        String tableName = ((SQLExprTableSource)joinTable).getExpr().toString();
        String alias = joinTable.getAlias();
        JoinTableInfo tableInfo = new JoinTableInfo();
        tableInfo.setTableName(tableName);
        tableInfo.setAlias(alias);
        return tableInfo;
    }
}

