package com.efuture.msboot.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionResource;
import com.efuture.msboot.base.context.impl.SessionContextImpl;
import com.efuture.msboot.core.utils.DiscoveryRestUtils;
import com.efuture.msboot.session.impl.DefaultSessionContextBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * Created by wzm on 2019/4/18.
 */
@Slf4j
public class PortalSessionContextBuilder extends DefaultSessionContextBuilder{

    @Override
    public SessionContext build(String ent_id, String user_id, String user_code, String user_name, String locale, String session, String token, Object... exts) {
        log.info(">>>> {}", session);

        SessionContext sessionContext = null;
        String selectShopId = null;

        if(exts.length>0){
            if(exts[0] != null && exts[0] instanceof JSONObject){
                JSONObject params = (JSONObject)exts[0];
                if(params.containsKey("selectShopId")){
                    selectShopId = params.getString("selectShopId");
                }
            }
        }

        if(StringUtils.hasText(session)){
            sessionContext = tryBuildFromSession(session, selectShopId);
        }

        if(sessionContext == null) {
            sessionContext = super.build(ent_id, user_id, user_code, user_name, locale, session, token);
        }

        return sessionContext;
    }

    private SessionContext tryBuildFromSession(String session, String selectShopId){
        try {
            String formatSession = session;

            if(session.startsWith("%7B%22")){
                formatSession = DiscoveryRestUtils.onURLDecoder(session, "utf-8");
            }

            //{"dataRangeId":0,"entCode":"0","ent_id":88,"locale":"zh","roleId":0,"stationId":0,"trace_id":"","user_code":"admin","user_id":2,"user_name":"系统管理员"}
            JSONObject jsonObject = JSON.parseObject(formatSession);
            String ent_id = jsonObject.getString("ent_id");
            String entCode = jsonObject.getString("entCode");
            String user_code = jsonObject.getString("user_code");
            String user_id = jsonObject.getString("user_id");
            String user_name = jsonObject.getString("user_name");
            String locale = jsonObject.getString("locale");
            String dataRangeId = jsonObject.getString("dataRangeId");

            SessionContextImpl sessionContext = new SessionContextImpl(ent_id, entCode, null, user_id, user_code, user_name, session, null, locale);

            // portal 中带有默认门店
            if(jsonObject.containsKey("shop_code") && StringUtils.hasText(jsonObject.getString("shop_code"))){
                List<SessionResource> sessionResourceList = new ArrayList<>();
                sessionContext.setResources(sessionResourceList);

                SessionResource sessionResource = new SessionResource();
                sessionResource.setType("shop");
                sessionResource.setCodes(new HashSet<String>());
                sessionResource.getCodes().add(jsonObject.getString("shop_code"));

                sessionResourceList.add(sessionResource);
            }else if(StringUtils.hasText(selectShopId)){
                List<SessionResource> sessionResourceList = new ArrayList<>();
                sessionContext.setResources(sessionResourceList);

                SessionResource sessionResource = new SessionResource();
                sessionResource.setType("shop");
                sessionResource.setCodes(new HashSet<String>());
                sessionResource.getCodes().add(selectShopId);

                sessionResourceList.add(sessionResource);
            }

            log.info(">> selectShopId:{}", selectShopId);

            return sessionContext;
        }catch (Exception e){
            log.error(e.getMessage());
        }
        return null;
    }
}
