package com.efuture.msboot.portal.service.impl;

import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.base.context.SessionResource;
import com.efuture.msboot.data.permission.impl.PermissionResourceServiceImpl;
import com.efuture.msboot.service.ShopSplitConfigService;
import com.efuture.msboot.service.bean.ShopSplitConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultPermissionResourceServiceImpl extends PermissionResourceServiceImpl {

    @Autowired
    ShopSplitConfigService shopSplitConfigService;

    @Override
    public Set<String> getResourceCodeSet(String resourceType){
        Set<String> codes = super.getResourceCodeSet(resourceType);
        if(!CollectionUtils.isEmpty(codes)){
            return codes;
        }

        if("splitcode".equalsIgnoreCase(resourceType)){
            List<ShopSplitConfig> shopSplitCodeList = shopSplitConfigService.listByShopIds(getShopResource());
            if(CollectionUtils.isEmpty(shopSplitCodeList)){
                return null;
            }

            codes = new HashSet<>();
            for(ShopSplitConfig item: shopSplitCodeList){
                if(item != null && StringUtils.hasText(item.getSplitcode())) {
                    codes.add(item.getSplitcode());
                }
            }
        }

        return codes;
    }

    private List<String> getShopResource(){
        List<SessionResource> sessionResourceList = SessionContextHolder.get().getResources();
        if(CollectionUtils.isEmpty(sessionResourceList)){
            return null;
        }

        for(SessionResource sr:sessionResourceList){
            if("shop".equalsIgnoreCase(sr.getType())){
                return new ArrayList<>(sr.getCodes());
            }
        }

        return null;
    }
}
