package com.efuture.msboot.portal.service.impl;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.embedded.LinkedHashMapCacheBuilder;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.service.ShopSplitConfigService;
import com.efuture.msboot.service.bean.ShopSplitConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 不建议在此类使用mybatis
 */
public class RocShopSplitConfigServiceImpl implements ShopSplitConfigService, InitializingBean {
    @Autowired
    DataSource dataSource;

    Cache<String,Object> localCache;

    JdbcTemplate jdbcTemplate;

    @PostConstruct
    public void init(){
        this.localCache = LinkedHashMapCacheBuilder.createLinkedHashMapCacheBuilder().buildCache();
    }

    @Override
    public ShopSplitConfig getByShopId(String shopid) {
        ShopSplitConfig shopSplitConfig = (ShopSplitConfig)this.localCache.get(shopid);
        if(shopSplitConfig == null){
            shopSplitConfig = fetchByShopId(shopid);

            if(shopSplitConfig != null) {
                this.localCache.put(shopid, fetchByShopId(shopid), 2L, TimeUnit.HOURS);
            }
        }

        if(shopSplitConfig == null){
            ExceptionUtils.raise("门店 ["+shopid +"] 未配置 splitcode");
        }

        return shopSplitConfig;
    }

    @Override
    public List<ShopSplitConfig> listByShopIds(List<String> shopIds) {
        if(CollectionUtils.isEmpty(shopIds)){
            return null;
        }

        List<ShopSplitConfig> list = new ArrayList<>();
        for(String shopid:shopIds){
            list.add(getByShopId(shopid));
        }

        return list;
    }

    private ShopSplitConfig fetchByShopId(String shopid){
        List<ShopSplitConfig> shopSplitConfigList = jdbcTemplate.query("select shopid, CONCAT(entid,dbcode) as splitcode from shopoffline where shopid='"+shopid+"'", new BeanPropertyRowMapper<>(ShopSplitConfig.class));

        return CollectionUtils.isEmpty(shopSplitConfigList)?null:shopSplitConfigList.get(0);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        jdbcTemplate = new JdbcTemplate(dataSource);
    }
}
