/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionResource;
import com.efuture.msboot.base.context.impl.SessionContextImpl;
import com.efuture.msboot.core.utils.DiscoveryRestUtils;
import com.efuture.msboot.session.impl.DefaultSessionContextBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PortalSessionContextBuilder
extends DefaultSessionContextBuilder {
    private static final Logger log = LoggerFactory.getLogger(PortalSessionContextBuilder.class);

    public SessionContext build(String ent_id, String user_id, String user_code, String user_name, String locale, String session, String token, Object ... exts) {
        JSONObject params;
        log.info(">>>> {}", (Object)session);
        SessionContext sessionContext = null;
        String selectShopId = null;
        if (exts.length > 0 && exts[0] != null && exts[0] instanceof JSONObject && (params = (JSONObject)exts[0]).containsKey((Object)"selectShopId")) {
            selectShopId = params.getString("selectShopId");
        }
        if (StringUtils.hasText((String)session)) {
            sessionContext = this.tryBuildFromSession(session, selectShopId);
        }
        if (sessionContext == null) {
            sessionContext = super.build(ent_id, user_id, user_code, user_name, locale, session, token, new Object[0]);
        }
        return sessionContext;
    }

    private SessionContext tryBuildFromSession(String session, String selectShopId) {
        try {
            String formatSession = session;
            if (session.startsWith("%7B%22")) {
                formatSession = DiscoveryRestUtils.onURLDecoder((String)session, (String)"utf-8");
            }
            JSONObject jsonObject = JSON.parseObject((String)formatSession);
            String ent_id = jsonObject.getString("ent_id");
            String entCode = jsonObject.getString("entCode");
            String user_code = jsonObject.getString("user_code");
            String user_id = jsonObject.getString("user_id");
            String user_name = jsonObject.getString("user_name");
            String locale = jsonObject.getString("locale");
            String dataRangeId = jsonObject.getString("dataRangeId");
            SessionContextImpl sessionContext = new SessionContextImpl(ent_id, entCode, null, user_id, user_code, user_name, session, null, locale);
            if (jsonObject.containsKey((Object)"shop_code") && StringUtils.hasText((String)jsonObject.getString("shop_code"))) {
                ArrayList<SessionResource> sessionResourceList = new ArrayList<SessionResource>();
                sessionContext.setResources(sessionResourceList);
                SessionResource sessionResource = new SessionResource();
                sessionResource.setType("shop");
                sessionResource.setCodes(new HashSet());
                sessionResource.getCodes().add(jsonObject.getString("shop_code"));
                sessionResourceList.add(sessionResource);
            } else if (StringUtils.hasText((String)selectShopId)) {
                ArrayList<SessionResource> sessionResourceList = new ArrayList<SessionResource>();
                sessionContext.setResources(sessionResourceList);
                SessionResource sessionResource = new SessionResource();
                sessionResource.setType("shop");
                sessionResource.setCodes(new HashSet());
                sessionResource.getCodes().add(selectShopId);
                sessionResourceList.add(sessionResource);
            }
            log.info(">> selectShopId:{}", (Object)selectShopId);
            return sessionContext;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

