/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.portal.service.impl;

import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.base.context.SessionResource;
import com.efuture.msboot.data.permission.impl.PermissionResourceServiceImpl;
import com.efuture.msboot.service.ShopSplitConfigService;
import com.efuture.msboot.service.bean.ShopSplitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultPermissionResourceServiceImpl
extends PermissionResourceServiceImpl {
    @Autowired
    ShopSplitConfigService shopSplitConfigService;

    public Set<String> getResourceCodeSet(String resourceType) {
        HashSet<String> codes = super.getResourceCodeSet(resourceType);
        if (!CollectionUtils.isEmpty((Collection)codes)) {
            return codes;
        }
        if ("splitcode".equalsIgnoreCase(resourceType)) {
            List shopSplitCodeList = this.shopSplitConfigService.listByShopIds(this.getShopResource());
            if (CollectionUtils.isEmpty((Collection)shopSplitCodeList)) {
                return null;
            }
            codes = new HashSet<String>();
            for (ShopSplitConfig item : shopSplitCodeList) {
                if (item == null || !StringUtils.hasText((String)item.getSplitcode())) continue;
                codes.add(item.getSplitcode());
            }
        }
        return codes;
    }

    private List<String> getShopResource() {
        List sessionResourceList = SessionContextHolder.get().getResources();
        if (CollectionUtils.isEmpty((Collection)sessionResourceList)) {
            return null;
        }
        for (SessionResource sr : sessionResourceList) {
            if (!"shop".equalsIgnoreCase(sr.getType())) continue;
            return new ArrayList<String>(sr.getCodes());
        }
        return null;
    }
}

