/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.portal.service.impl;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.embedded.LinkedHashMapCacheBuilder;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.service.ShopSplitConfigService;
import com.efuture.msboot.service.bean.ShopSplitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class PosShopSplitConfigServiceImpl
implements ShopSplitConfigService,
InitializingBean {
    @Autowired
    DataSource dataSource;
    Cache<String, Object> localCache;
    JdbcTemplate jdbcTemplate;

    @PostConstruct
    public void init() {
        this.localCache = LinkedHashMapCacheBuilder.createLinkedHashMapCacheBuilder().buildCache();
    }

    public ShopSplitConfig getByShopId(String shopid) {
        ShopSplitConfig shopSplitConfig = (ShopSplitConfig)this.localCache.get((Object)shopid);
        if (shopSplitConfig == null && (shopSplitConfig = this.fetchByShopId(shopid)) != null) {
            this.localCache.put((Object)shopid, (Object)this.fetchByShopId(shopid), 2L, TimeUnit.HOURS);
        }
        if (shopSplitConfig == null) {
            ExceptionUtils.raise((String)("\u95e8\u5e97 [" + shopid + "] \u672a\u914d\u7f6e splitcode"));
        }
        return shopSplitConfig;
    }

    public List<ShopSplitConfig> listByShopIds(List<String> shopIds) {
        if (CollectionUtils.isEmpty(shopIds)) {
            return null;
        }
        ArrayList<ShopSplitConfig> list = new ArrayList<ShopSplitConfig>();
        for (String shopid : shopIds) {
            list.add(this.getByShopId(shopid));
        }
        return list;
    }

    private ShopSplitConfig fetchByShopId(String shopid) {
        List shopSplitConfigList = this.jdbcTemplate.query("select shopcode as shopid,splitcode from splitconfig where shopcode='" + shopid + "'", (RowMapper)new BeanPropertyRowMapper(ShopSplitConfig.class));
        return CollectionUtils.isEmpty((Collection)shopSplitConfigList) ? null : (ShopSplitConfig)shopSplitConfigList.get(0);
    }

    public void afterPropertiesSet() throws Exception {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }
}

