/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.aop;

import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.service.annotation.Search;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Aspect
@Component
@Order(value=0)
public class SearchAop {
    private static final Logger log = LoggerFactory.getLogger(SearchAop.class);

    @Pointcut(value="@annotation(com.efuture.msboot.service.annotation.Search)")
    public void searchHandle() {
    }

    @Before(value="searchHandle()")
    public void doBefore(JoinPoint joinPoint) {
        String[] conditonFieldDefine;
        Search search = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(Search.class);
        if (search == null) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        if (args == null) {
            return;
        }
        SearchInfo searchInfo = null;
        for (Object obj : args) {
            if (!(obj instanceof SearchInfo)) continue;
            searchInfo = (SearchInfo)obj;
            break;
        }
        if (searchInfo == null) {
            return;
        }
        Map params = searchInfo.getParams();
        boolean existConditionExpr = StringUtils.hasLength((String)searchInfo.getCondition());
        for (String define : conditonFieldDefine = search.conditonFieldDefine()) {
            String[] record = define.split(":");
            if (record.length != 2) {
                ExceptionUtils.raise((String)("conditonFieldDefine \u9519\u8bef " + define));
            }
            String orgiField = record[0].trim();
            String targetField = record[1].trim();
            if (existConditionExpr) {
                String expr = searchInfo.getCondition();
                expr = expr.replace("${" + orgiField + "}", "${#}");
                expr = expr.replace(orgiField, targetField);
                expr = expr.replace("${#}", "${" + orgiField + "}");
                searchInfo.setCondition(expr);
                continue;
            }
            if (CollectionUtils.isEmpty((Map)params) || !params.containsKey(orgiField)) continue;
            params.put(targetField, params.get(orgiField));
            params.remove(orgiField);
        }
    }

    @After(value="searchHandle()")
    public void doAfter() {
    }
}

