/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.msboot.service.impl;

import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.msboot.base.context.SessionContext;
import com.efuture.msboot.base.context.SessionContextHolder;
import com.efuture.msboot.core.bean.EasyBeanWrapper;
import com.efuture.msboot.core.bean.SimpleBeanUtils;
import com.efuture.msboot.core.map.StringObjectMap;
import com.efuture.msboot.core.utils.ExceptionUtils;
import com.efuture.msboot.data.DataAccess;
import com.efuture.msboot.data.ViewAccess;
import com.efuture.msboot.data.bean.CURDEnum;
import com.efuture.msboot.data.bean.DataPage;
import com.efuture.msboot.data.bean.Query;
import com.efuture.msboot.data.bean.SlaveInfo;
import com.efuture.msboot.data.query.SqlBuilder;
import com.efuture.msboot.data.query.bean.SearchInfo;
import com.efuture.msboot.data.utils.EntityUtils;
import com.efuture.msboot.data.utils.SearchUtils;
import com.efuture.msboot.data.utils.SlaveUtils;
import com.efuture.msboot.service.BaseSheetService;
import com.efuture.msboot.service.annotation.Search;
import com.efuture.msboot.service.annotation.Sheet;
import com.efuture.msboot.service.sheet.SheetFlagDefine;
import com.efuture.msboot.service.sheet.SheetGlobalConfig;
import com.efuture.msboot.service.sheet.SheetPropertyDefine;
import com.efuture.msboot.service.sheet.SheetUtils;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class BaseSheetServiceImpl<T>
implements BaseSheetService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseSheetServiceImpl.class);
    @Lazy
    @Autowired(required=false)
    protected DataAccess dataAccess;
    @Lazy
    @Autowired(required=false)
    protected ViewAccess viewAccess;
    @Autowired
    protected SqlBuilder sqlBuilder;
    @Autowired
    protected SheetGlobalConfig sheetGlobalConfig;
    protected Class beanClazz;
    protected Sheet sheetAnnotation;
    protected Search searchAnnotation;
    protected int sheetType;
    protected boolean execAfterCommit;
    protected boolean asyncExecture = false;
    protected boolean checkSheetFlag = true;
    protected SheetPropertyDefine sheetPropertyDefine;
    protected SheetFlagDefine sheetFlagDefine;

    public BaseSheetServiceImpl() {
        this(0);
    }

    public BaseSheetServiceImpl(int sheetType) {
        this.sheetType = sheetType;
    }

    @PostConstruct
    public void init() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.beanClazz = (Class)type.getActualTypeArguments()[0];
        this.searchAnnotation = this.getClass().getAnnotation(Search.class);
        this.sheetAnnotation = this.getClass().getAnnotation(Sheet.class);
        if (this.sheetAnnotation != null) {
            this.sheetType = this.sheetAnnotation.sheetType();
            this.execAfterCommit = this.sheetAnnotation.execAfterCommit();
            this.asyncExecture = this.sheetAnnotation.asyncExecture();
            this.checkSheetFlag = this.sheetAnnotation.checkSheetFlag();
        }
        if (this.sheetPropertyDefine == null) {
            this.sheetPropertyDefine = new SheetPropertyDefine();
            SimpleBeanUtils.copyProperties((Object)this.sheetPropertyDefine, (Object)this.sheetGlobalConfig);
        }
        if (this.sheetFlagDefine == null) {
            this.sheetFlagDefine = new SheetFlagDefine();
            SimpleBeanUtils.copyProperties((Object)this.sheetFlagDefine, (Object)this.sheetGlobalConfig);
        }
        this.config();
    }

    @Override
    public T get(Serializable id) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return this.get(id, true);
    }

    @Override
    public T get(Serializable id, boolean returnSheetDetails) {
        return (T)this.viewAccess.selectById(id, this.beanClazz, Boolean.valueOf(returnSheetDetails));
    }

    @Override
    public T getBySheetId(String sheetId) {
        return this.getBySheetId(sheetId, true);
    }

    @Override
    public T getBySheetId(String sheetId, boolean returnSheetDetails) {
        List resultList = this.dataAccess.selectByMap((Map)StringObjectMap.create((Object[])new Object[]{this.sheetPropertyDefine.getSheetIdProperty(), sheetId}), this.beanClazz);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        Object entity = resultList.get(0);
        Serializable id = EntityUtils.getIdValue(entity);
        return this.get(id, returnSheetDetails);
    }

    @Override
    public Object getFlag(Serializable id) {
        Object value;
        T entity = this.get(id, false);
        if (entity == null) {
            ExceptionUtils.raise((String)("\u5355\u636eid " + id + " \u4e0d\u5b58\u5728"));
        }
        if ((value = EntityUtils.getPropertyValue(entity, (String)this.sheetPropertyDefine.getFlagProperty())) == null) {
            ExceptionUtils.raise((String)("\u5355\u636eid " + id + " flag \u4e0d\u5b58\u5728"));
        }
        return value;
    }

    @Override
    public Object getFlag(String sheetId) {
        Object value;
        T entity = this.getBySheetId(sheetId, false);
        if (entity == null) {
            ExceptionUtils.raise((String)("\u5355\u636e " + sheetId + " \u4e0d\u5b58\u5728"));
        }
        if ((value = EntityUtils.getPropertyValue(entity, (String)this.sheetPropertyDefine.getFlagProperty())) == null) {
            ExceptionUtils.raise((String)("\u5355\u636e " + sheetId + " flag \u4e0d\u5b58\u5728"));
        }
        return value;
    }

    @Override
    public boolean exist(Serializable id) {
        T entity = this.get(id, false);
        return entity != null;
    }

    @Override
    public boolean exist(String sheetId) {
        T entity = this.getBySheetId(sheetId, false);
        return entity != null;
    }

    @Override
    @Transactional
    public T add(T entity) {
        EntityUtils.initInsert(entity);
        this.setNewSheetId(entity);
        this.beforeAdd(entity);
        this.dataAccess.insert(entity);
        this.afterAdd(entity);
        return this.get(EntityUtils.getIdValue(entity));
    }

    @Override
    @Transactional
    public T update(T entity) {
        EntityUtils.initUpdate(entity);
        this.beforeUpdate(entity);
        this.checkSheetFlag(EntityUtils.getIdValue(entity));
        this.dataAccess.updateById(entity);
        this.afterUpdate(entity);
        return this.get(EntityUtils.getIdValue(entity));
    }

    @Override
    @Transactional
    public void delete(Serializable id) {
        Assert.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        T entity = this.get(id, false);
        if (entity == null) {
            return;
        }
        this.checkSheetFlag(id);
        this.beforeDelete(entity);
        this.dataAccess.deleteById(id, this.beanClazz, Boolean.valueOf(true));
        this.afterDelete(entity);
    }

    @Override
    @Transactional
    public T save(T entity) {
        String saveType;
        String string = saveType = EntityUtils.hasIdValue(entity) != false ? CURDEnum.UPDATE.toString() : CURDEnum.INSERT.toString();
        if (CURDEnum.INSERT.toString().equals(saveType)) {
            EntityUtils.initInsert(entity);
            this.setNewSheetId(entity);
            this.dataAccess.insert(entity);
        } else {
            EntityUtils.initUpdate(entity);
            this.checkSheetFlag(EntityUtils.getIdValue(entity));
            this.dataAccess.updateById(entity);
        }
        this.saveItems(entity);
        return this.get(EntityUtils.getIdValue(entity));
    }

    @Override
    @Transactional
    public void batchDelete(List<Serializable> ids) {
        Assert.notEmpty(ids, (String)"ids \u4e0d\u80fd\u4e3a\u7a7a");
        for (Serializable id : ids) {
            this.delete(id);
        }
    }

    @Override
    public DataPage<T> search(SearchInfo searchInfo) {
        if (searchInfo == null) {
            searchInfo = new SearchInfo();
        }
        searchInfo.setEntityClazz(this.beanClazz);
        String sqlTemplate = this.sqlBuilder.buildSqlTemplate(searchInfo);
        log.info(">>>> \n >> searchInfo: {}, \n >> sql: {}", (Object)searchInfo, (Object)sqlTemplate);
        return this.dataAccess.selectSqlPage(sqlTemplate, searchInfo.getParams(), searchInfo.getPageNo().intValue(), searchInfo.getPageSize().intValue(), this.beanClazz);
    }

    @Override
    @Transactional
    public void commit(Serializable id) {
        T entity = this.get(id);
        if (entity == null) {
            ExceptionUtils.raise((String)("\u5355\u636e" + id + " \u4e0d\u5b58\u5728"));
        }
        this.checkSheetFlag(id);
        this.beforeCommit(entity);
        EasyBeanWrapper beanWrapper = new EasyBeanWrapper(entity);
        beanWrapper.setPropertyValueIfExist(this.sheetPropertyDefine.getFlagProperty(), this.sheetFlagDefine.getSheet_checked_flag().get(0));
        SessionContext sessionContext = SessionContextHolder.get();
        if (sessionContext != null) {
            beanWrapper.setPropertyValueIfExist(this.sheetPropertyDefine.getCheckerProperty(), (Object)sessionContext.getUserName());
            beanWrapper.setPropertyValueIfExist(this.sheetPropertyDefine.getCheckDateProperty(), (Object)new Date());
        }
        this.dataAccess.updateById(entity);
        this.afterCommit(entity);
        if (this.execAfterCommit) {
            this.execture(id);
        }
    }

    @Override
    public void execture(Serializable id) {
        if (!this.asyncExecture) {
            this.doExecture(id);
        } else {
            log.info(">>\u5f02\u6b65\u6267\u884c\u5355\u636e[{}]", (Object)id);
        }
    }

    @Override
    public String getNewSheetId() {
        return SheetUtils.getNewSheetId(this.sheetType);
    }

    @Override
    public String getNewSheetId(String shopid) {
        return SheetUtils.getNewSheetId(this.sheetType, shopid);
    }

    @Override
    public void setNewSheetId(T entity) {
        EasyBeanWrapper easyBeanWrapper = new EasyBeanWrapper(entity);
        String shopid = (String)easyBeanWrapper.getPropertyValueIfExist(this.sheetPropertyDefine.getShopidProperty());
        String newSheetId = SheetUtils.getNewSheetId(this.sheetType, shopid);
        easyBeanWrapper.setPropertyValueIfExist(this.sheetPropertyDefine.getSheetIdProperty(), (Object)newSheetId);
    }

    @Override
    public int getSheetType() {
        return this.sheetType;
    }

    protected void config() {
    }

    protected void beforeAdd(T entity) {
    }

    protected void afterAdd(T entity) {
    }

    protected void beforeUpdate(T entity) {
    }

    protected void afterUpdate(T entity) {
    }

    protected void beforeDelete(T entity) {
    }

    protected void afterDelete(T entity) {
    }

    protected void beforeCommit(T entity) {
    }

    protected void afterCommit(T entity) {
    }

    protected void doExecture(Serializable id) {
    }

    protected void saveItems(T entity) {
        List slaveInfoList = SlaveUtils.getSlaveInfoList((Class)this.beanClazz);
        if (CollectionUtils.isEmpty((Collection)slaveInfoList)) {
            return;
        }
        BeanWrapperImpl masterWrapper = new BeanWrapperImpl(entity);
        String sheetid = (String)masterWrapper.getPropertyValue(this.sheetPropertyDefine.getSheetIdProperty());
        for (SlaveInfo slaveInfo : slaveInfoList) {
            String curd_flag;
            EasyBeanWrapper slaveWrapper;
            List slaveDataList = (List)masterWrapper.getPropertyValue(slaveInfo.getFieldName());
            if (CollectionUtils.isEmpty((Collection)slaveDataList)) continue;
            List refFields = slaveInfo.getRefFields();
            Integer maxSerialId = 0;
            Boolean hasSerialid = null;
            for (Object slaveData : slaveDataList) {
                slaveWrapper = new EasyBeanWrapper(slaveData);
                if (!slaveWrapper.getPropertiesSet().contains("curd_flag")) continue;
                String string = curd_flag = slaveWrapper.getPropertyValue("curd_flag") == null ? "U" : String.valueOf(slaveWrapper.getPropertyValue("curd_flag"));
                if (!CURDEnum.DELETE.toString().equalsIgnoreCase(curd_flag)) continue;
                Serializable idValue = EntityUtils.getIdValue(slaveData);
                this.dataAccess.deleteById(idValue, slaveInfo.getSlaveClazz());
            }
            for (Object slaveData : slaveDataList) {
                slaveWrapper = new EasyBeanWrapper(slaveData);
                curd_flag = EntityUtils.getCurdFlag(slaveData);
                if (CURDEnum.INSERT.toString().equalsIgnoreCase(curd_flag)) {
                    if (hasSerialid == null && (hasSerialid = Boolean.valueOf(slaveWrapper.getPropertiesSet().contains(this.sheetPropertyDefine.getDetail_SerialId()))).booleanValue()) {
                        maxSerialId = this.getMaxSerialId(sheetid, slaveInfo.getSlaveClazz());
                    }
                    if (!CollectionUtils.isEmpty((Collection)refFields)) {
                        for (String refField : refFields) {
                            slaveWrapper.setPropertyValueIfNull(refField, masterWrapper.getPropertyValue(refField));
                        }
                    }
                    if (hasSerialid.booleanValue()) {
                        maxSerialId = maxSerialId + 1;
                        slaveWrapper.setPropertyValueIfNull(this.sheetPropertyDefine.getDetail_SerialId(), (Object)maxSerialId);
                    }
                    EntityUtils.initInsert(slaveData);
                    this.dataAccess.insert(slaveData);
                    continue;
                }
                if (CURDEnum.UPDATE.toString().equalsIgnoreCase(curd_flag)) {
                    EntityUtils.initUpdate(slaveData);
                    this.dataAccess.updateById(slaveData);
                    continue;
                }
                log.warn("\u65e0\u6cd5\u5904\u7406\u6807\u8bc6 " + curd_flag);
            }
        }
    }

    protected int getMaxSerialId(String sheetId, Class sheetItemClazz) {
        Query query = new Query();
        query.eq(this.sheetPropertyDefine.getSheetIdProperty(), (Object)sheetId);
        Object value = this.dataAccess.selectMax(this.sheetPropertyDefine.getDetail_SerialId(), query, sheetItemClazz);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt((Object)value);
    }

    private void checkSearchRef(SearchInfo searchInfo) {
        if (this.searchAnnotation == null) {
            ExceptionUtils.raise((String)"\u672a\u914d\u7f6esearch\u63a5\u53e3");
        }
        if (this.searchAnnotation.refs() == null || this.searchAnnotation.refs().length == 0) {
            ExceptionUtils.raise((String)"\u672a\u914d\u7f6esearch.refs\u63a5\u53e3");
        }
        SearchUtils.checkSearchRef((SearchInfo)searchInfo, Arrays.asList(this.searchAnnotation.refs()));
    }

    protected void checkSheetFlag(Serializable id) {
        if (id == null || !this.checkSheetFlag) {
            return;
        }
        Object flag = this.getFlag(id);
        this.checkSheetFlag(flag);
    }

    public void checkSheetFlag(Object flag) {
        if (flag == null) {
            return;
        }
        String strFlag = TypeUtils.castToString((Object)flag);
        if (!CollectionUtils.isEmpty(this.sheetFlagDefine.getSheet_checked_flag())) {
            for (Object value : this.sheetFlagDefine.getSheet_checked_flag()) {
                if (!TypeUtils.castToString((Object)value).equals(strFlag)) continue;
                ExceptionUtils.raise((String)"\u5355\u636e\u5df2\u5ba1\u6838");
            }
        }
        if (TypeUtils.castToString((Object)this.sheetFlagDefine.getSheet_cancel_flag()).equals(strFlag)) {
            ExceptionUtils.raise((String)"\u5355\u636e\u5df2\u53d6\u6d88");
        }
        if (TypeUtils.castToString((Object)this.sheetFlagDefine.getSheet_complete_flag()).equals(strFlag)) {
            ExceptionUtils.raise((String)"\u5355\u636e\u5df2\u5b8c\u6210");
        }
    }
}

